/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.gradle.security.internal.PGPUtils;

public class KeyringStripper {
    private static final Constructor<PGPPublicKey> KEY_CONSTRUCTOR;
    private static final Constructor<PGPPublicKey> SUBKEY_CONSTRUCTOR;

    public static PGPPublicKeyRing strip(PGPPublicKeyRing keyring, KeyFingerPrintCalculator fingerprintCalculator) {
        List strippedKeys = StreamSupport.stream(keyring.spliterator(), false).map(key -> KeyringStripper.stripKey(key, fingerprintCalculator)).collect(Collectors.toList());
        return new PGPPublicKeyRing(strippedKeys);
    }

    private static PGPPublicKey stripKey(PGPPublicKey key, KeyFingerPrintCalculator fingerprintCalculator) {
        try {
            PGPPublicKey stripped;
            if (key.isMasterKey()) {
                List<Object> idSignatures;
                List<Object> ids;
                Optional<String> id = PGPUtils.getUserIDs(key).stream().filter(KeyringStripper::looksLikeEmail).min(Comparator.comparing(String::length));
                if (id.isPresent()) {
                    ids = Collections.singletonList(new UserIDPacket(id.get()));
                    idSignatures = Collections.singletonList(Collections.emptyList());
                } else {
                    ids = Collections.emptyList();
                    idSignatures = Collections.emptyList();
                }
                stripped = KEY_CONSTRUCTOR.newInstance(key.getPublicKeyPacket(), null, Collections.emptyList(), ids, Collections.singletonList(null), idSignatures, fingerprintCalculator);
            } else {
                stripped = SUBKEY_CONSTRUCTOR.newInstance(key.getPublicKeyPacket(), null, ImmutableList.copyOf((Iterator)key.getKeySignatures()), fingerprintCalculator);
            }
            return stripped;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean looksLikeEmail(String id) {
        return id.length() >= 5 && id.contains("@");
    }

    private static Constructor<PGPPublicKey> getKeyConstructor() throws NoSuchMethodException {
        Constructor<PGPPublicKey> constructor = PGPPublicKey.class.getDeclaredConstructor(PublicKeyPacket.class, TrustPacket.class, List.class, List.class, List.class, List.class, KeyFingerPrintCalculator.class);
        constructor.setAccessible(true);
        return constructor;
    }

    private static Constructor<PGPPublicKey> getSubkeyConstructor() throws NoSuchMethodException {
        Constructor<PGPPublicKey> constructor = PGPPublicKey.class.getDeclaredConstructor(PublicKeyPacket.class, TrustPacket.class, List.class, KeyFingerPrintCalculator.class);
        constructor.setAccessible(true);
        return constructor;
    }

    static {
        try {
            KEY_CONSTRUCTOR = KeyringStripper.getKeyConstructor();
            SUBKEY_CONSTRUCTOR = KeyringStripper.getSubkeyConstructor();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

