/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.internal.execution;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.detection.TestDetector;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestDescriptor;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestScraper;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestSelection;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestTestExecutionSpec;
import org.gradle.process.ExecResult;
import org.gradle.process.ProcessExecutionException;
import org.gradle.process.internal.ClientExecHandleBuilder;
import org.gradle.process.internal.ClientExecHandleBuilderFactory;
import org.gradle.process.internal.ExecHandle;

public abstract class XCTestExecuter
implements TestExecuter<XCTestTestExecutionSpec> {
    @Inject
    public abstract ClientExecHandleBuilderFactory getExecHandleFactory();

    @Inject
    public abstract WorkerLeaseService getWorkerLeaseService();

    public IdGenerator<?> getIdGenerator() {
        return new LongIdGenerator();
    }

    @Inject
    public abstract Clock getClock();

    @Inject
    public abstract Clock getTimeProvider();

    public void execute(XCTestTestExecutionSpec testExecutionSpec, TestResultProcessor testResultProcessor) {
        File executable = testExecutionSpec.getRunScript();
        File workingDir = testExecutionSpec.getWorkingDir();
        String rootTestSuiteId = testExecutionSpec.getPath();
        XCTestProcessor processor = new XCTestProcessor(this.getClock(), executable, workingDir, this.getExecHandleFactory().newExecHandleBuilder(), this.getIdGenerator(), rootTestSuiteId);
        XCTestDetector detector = new XCTestDetector(processor, testExecutionSpec.getTestSelection());
        new TestMainAction((TestDetector)detector, (TestClassProcessor)processor, testResultProcessor, this.getWorkerLeaseService(), this.getTimeProvider(), (Object)rootTestSuiteId, "Gradle Test Run " + testExecutionSpec.getPath()).run();
    }

    public void stopNow() {
        throw new UnsupportedOperationException("XCTest does not support failing fast on first test failure.");
    }

    static class XCTestProcessor
    implements TestClassProcessor {
        private TestResultProcessor resultProcessor;
        private ExecHandle execHandle;
        private final ClientExecHandleBuilder execHandleBuilder;
        private final IdGenerator<?> idGenerator;
        private final Clock clock;
        private final String rootTestSuiteId;

        @Inject
        public XCTestProcessor(Clock clock, File executable, File workingDir, ClientExecHandleBuilder execHandleBuilder, IdGenerator<?> idGenerator, String rootTestSuiteId) {
            this.execHandleBuilder = execHandleBuilder;
            this.idGenerator = idGenerator;
            this.clock = clock;
            this.rootTestSuiteId = rootTestSuiteId;
            execHandleBuilder.setExecutable(executable.getAbsolutePath());
            execHandleBuilder.setWorkingDir(workingDir);
        }

        public void startProcessing(TestResultProcessor resultProcessor) {
            this.resultProcessor = resultProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTestClass(TestClassRunInfo testClass) {
            ArrayDeque<XCTestDescriptor> testDescriptors = new ArrayDeque<XCTestDescriptor>();
            XCTestScraper stdOut = new XCTestScraper(TestOutputEvent.Destination.StdOut, this.resultProcessor, this.idGenerator, this.clock, this.rootTestSuiteId, testDescriptors);
            XCTestScraper stdErr = new XCTestScraper(TestOutputEvent.Destination.StdErr, this.resultProcessor, this.idGenerator, this.clock, this.rootTestSuiteId, testDescriptors);
            String lineSeparator = SystemProperties.getInstance().getLineSeparator();
            this.execHandle = this.executeTest(testClass.getTestClassName(), (OutputStream)new LineBufferingOutputStream((TextStream)stdOut, lineSeparator), (OutputStream)new LineBufferingOutputStream((TextStream)stdErr, lineSeparator));
            try {
                this.execHandle.start();
                ExecResult result = this.execHandle.waitForFinish();
                if (result.getExitValue() != 0 && result.getExitValue() != 1) {
                    result.rethrowFailure().assertNormalExitValue();
                }
            }
            catch (ProcessExecutionException e) {
                stdOut.endOfStream(e);
                stdErr.endOfStream(null);
            }
            finally {
                this.execHandle = null;
            }
        }

        private ExecHandle executeTest(String testName, OutputStream outputStream, OutputStream errorStream) {
            this.execHandleBuilder.setArgs(XCTestProcessor.toTestArgs(testName));
            this.execHandleBuilder.setStandardOutput(outputStream);
            this.execHandleBuilder.setErrorOutput(errorStream);
            return this.execHandleBuilder.build();
        }

        private static List<String> toTestArgs(String testName) {
            ArrayList<String> args = new ArrayList<String>();
            if (!testName.equals("All")) {
                if (OperatingSystem.current().isMacOsX()) {
                    args.add("-XCTest");
                }
                args.add(testName);
            }
            return args;
        }

        public void stop() {
            if (this.execHandle != null) {
                this.execHandle.abort();
                this.execHandle.waitForFinish();
            }
        }

        public void stopNow() {
            throw new UnsupportedOperationException("XCTest does not support failing fast on first test failure.");
        }
    }

    private static class XCTestDetector
    implements TestDetector {
        private final TestClassProcessor testClassProcessor;
        private final XCTestSelection testSelection;

        XCTestDetector(TestClassProcessor testClassProcessor, XCTestSelection testSelection) {
            this.testClassProcessor = testClassProcessor;
            this.testSelection = testSelection;
        }

        public void detect() {
            for (String includedTests : this.testSelection.getIncludedTests()) {
                DefaultTestClassRunInfo testClass = new DefaultTestClassRunInfo(includedTests);
                this.testClassProcessor.processTestClass((TestClassRunInfo)testClass);
            }
        }
    }
}

