/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.evaluation.AnalysisStatementFilter;
import org.gradle.internal.declarativedsl.analysis.AnalysisStatementFiltersImplementations;
import org.gradle.internal.declarativedsl.language.DataStatement;
import org.gradle.internal.declarativedsl.language.FunctionArgument;
import org.gradle.internal.declarativedsl.language.FunctionCall;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000e"}, d2={"analyzeEverything", "Lorg/gradle/declarative/dsl/evaluation/AnalysisStatementFilter;", "getAnalyzeEverything", "()Lorg/gradle/declarative/dsl/evaluation/AnalysisStatementFilter;", "and", "other", "or", "implies", "not", "shouldAnalyzeStatement", "", "statement", "Lorg/gradle/internal/declarativedsl/language/DataStatement;", "isTopLevel", "declarative-dsl-core"})
public final class AnalysisStatementFilterKt {
    @NotNull
    private static final AnalysisStatementFilter analyzeEverything = (AnalysisStatementFilter)new AnalysisStatementFiltersImplementations.DefaultAnalyzeEverythingFilter();

    @NotNull
    public static final AnalysisStatementFilter getAnalyzeEverything() {
        return analyzeEverything;
    }

    @NotNull
    public static final AnalysisStatementFilter and(@NotNull AnalysisStatementFilter $this$and, @NotNull AnalysisStatementFilter other) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (AnalysisStatementFilter)new AnalysisStatementFiltersImplementations.DefaultAndFilter($this$and, other);
    }

    @NotNull
    public static final AnalysisStatementFilter or(@NotNull AnalysisStatementFilter $this$or, @NotNull AnalysisStatementFilter other) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (AnalysisStatementFilter)new AnalysisStatementFiltersImplementations.DefaultOrFilter($this$or, other);
    }

    @NotNull
    public static final AnalysisStatementFilter implies(@NotNull AnalysisStatementFilter $this$implies, @NotNull AnalysisStatementFilter other) {
        Intrinsics.checkNotNullParameter((Object)$this$implies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return AnalysisStatementFilterKt.or(AnalysisStatementFilterKt.not($this$implies), other);
    }

    @NotNull
    public static final AnalysisStatementFilter not(@NotNull AnalysisStatementFilter $this$not) {
        Intrinsics.checkNotNullParameter((Object)$this$not, (String)"<this>");
        return (AnalysisStatementFilter)new AnalysisStatementFiltersImplementations.DefaultNotFilter($this$not);
    }

    public static final boolean shouldAnalyzeStatement(@NotNull AnalysisStatementFilter $this$shouldAnalyzeStatement, @NotNull DataStatement statement, boolean isTopLevel) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$shouldAnalyzeStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        AnalysisStatementFilter analysisStatementFilter = $this$shouldAnalyzeStatement;
        if (analysisStatementFilter instanceof AnalysisStatementFilter.AnalyzeEverythingFilter) {
            bl = true;
        } else if (analysisStatementFilter instanceof AnalysisStatementFilter.CompositionFilter.AndFilter) {
            bl = AnalysisStatementFilterKt.shouldAnalyzeStatement(((AnalysisStatementFilter.CompositionFilter.AndFilter)$this$shouldAnalyzeStatement).getLeft(), statement, isTopLevel) && AnalysisStatementFilterKt.shouldAnalyzeStatement(((AnalysisStatementFilter.CompositionFilter.AndFilter)$this$shouldAnalyzeStatement).getRight(), statement, isTopLevel);
        } else if (analysisStatementFilter instanceof AnalysisStatementFilter.CompositionFilter.OrFilter) {
            bl = AnalysisStatementFilterKt.shouldAnalyzeStatement(((AnalysisStatementFilter.CompositionFilter.OrFilter)$this$shouldAnalyzeStatement).getLeft(), statement, isTopLevel) || AnalysisStatementFilterKt.shouldAnalyzeStatement(((AnalysisStatementFilter.CompositionFilter.OrFilter)$this$shouldAnalyzeStatement).getRight(), statement, isTopLevel);
        } else if (analysisStatementFilter instanceof AnalysisStatementFilter.ConfiguringCallFilter) {
            bl = statement instanceof FunctionCall && CollectionsKt.singleOrNull(((FunctionCall)statement).getArgs()) instanceof FunctionArgument.Lambda;
        } else if (analysisStatementFilter instanceof AnalysisStatementFilter.NamedCallFilter) {
            bl = statement instanceof FunctionCall && Intrinsics.areEqual((Object)((FunctionCall)statement).getName(), (Object)((AnalysisStatementFilter.NamedCallFilter)$this$shouldAnalyzeStatement).getCallName());
        } else if (analysisStatementFilter instanceof AnalysisStatementFilter.NotFilter) {
            bl = !AnalysisStatementFilterKt.shouldAnalyzeStatement(((AnalysisStatementFilter.NotFilter)$this$shouldAnalyzeStatement).getNegationOf(), statement, isTopLevel);
        } else if (analysisStatementFilter instanceof AnalysisStatementFilter.TopLevelElementFilter) {
            bl = isTopLevel;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

