/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.dispatch.DispatchException;

public class MaxNParallelTestDefinitionProcessor<D extends TestDefinition>
implements TestDefinitionProcessor<D> {
    private final int maxProcessors;
    private final Factory<TestDefinitionProcessor<D>> factory;
    private final ActorFactory actorFactory;
    private TestResultProcessor resultProcessor;
    private int pos;
    private final List<TestDefinitionProcessor<D>> processors = new ArrayList<TestDefinitionProcessor<D>>();
    private final List<TestDefinitionProcessor<D>> rawProcessors = new ArrayList<TestDefinitionProcessor<D>>();
    private final List<Actor> actors = new ArrayList<Actor>();
    private Actor resultProcessorActor;
    private volatile boolean stoppedNow;

    public MaxNParallelTestDefinitionProcessor(int maxProcessors, Factory<TestDefinitionProcessor<D>> factory, ActorFactory actorFactory) {
        this.maxProcessors = maxProcessors;
        this.factory = factory;
        this.actorFactory = actorFactory;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessorActor = this.actorFactory.createActor((Object)resultProcessor);
        this.resultProcessor = (TestResultProcessor)this.resultProcessorActor.getProxy(TestResultProcessor.class);
    }

    public void processTestDefinition(D testDefinition) {
        TestDefinitionProcessor processor;
        if (this.stoppedNow) {
            return;
        }
        if (this.processors.size() < this.maxProcessors) {
            processor = (TestDefinitionProcessor)this.factory.create();
            this.rawProcessors.add(processor);
            Actor actor = this.actorFactory.createActor(processor);
            processor = (TestDefinitionProcessor)Cast.uncheckedNonnullCast((Object)actor.getProxy(TestDefinitionProcessor.class));
            this.actors.add(actor);
            this.processors.add(processor);
            processor.startProcessing(this.resultProcessor);
        } else {
            processor = this.processors.get(this.pos);
            this.pos = (this.pos + 1) % this.processors.size();
        }
        processor.processTestDefinition(testDefinition);
    }

    public void stop() {
        try {
            CompositeStoppable.stoppable(this.processors).add(this.actors).add((Object)this.resultProcessorActor).stop();
        }
        catch (DispatchException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
    }

    public void stopNow() {
        this.stoppedNow = true;
        for (TestDefinitionProcessor<D> processor : this.rawProcessors) {
            processor.stopNow();
        }
    }
}

