/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.rendering;

import java.io.PrintWriter;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.problems.internal.rendering.PartialProblemWriter;
import org.gradle.problems.internal.rendering.RenderOptions;

class ProblemHeaderWriter
implements PartialProblemWriter {
    @Override
    public void write(InternalProblem problem, RenderOptions options, PrintWriter output) {
        output.print(this.headerFor(options, problem));
    }

    private String headerFor(RenderOptions options, InternalProblem problem) {
        StringBuilder result = new StringBuilder(options.getPrefix());
        String displayName = problem.getDefinition().getId().getDisplayName();
        String name = displayName == null || displayName.isEmpty() ? problem.getDefinition().getId().toString() : displayName;
        name = name.replaceAll("\\r?\\n", " ");
        result.append(name);
        if (options.isRenderId() && displayName != null && !displayName.isEmpty()) {
            result.append(" (id: ");
            result.append(problem.getDefinition().getId());
            result.append(")");
        }
        return result.toString();
    }
}

