/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.List;
import java.util.Map;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.PropertiesConverter;

public abstract class BuildOptionSet<T> {
    public abstract List<? extends BuildOption<? super T>> getAllOptions();

    public CommandLineConverter<T> commandLineConverter() {
        return new AbstractCommandLineConverter<T>(){

            public T convert(ParsedCommandLine args, T target) throws CommandLineArgumentException {
                for (BuildOption option : BuildOptionSet.this.getAllOptions()) {
                    option.applyFromCommandLine(args, target);
                }
                return target;
            }

            public void configure(CommandLineParser parser) {
                for (BuildOption option : BuildOptionSet.this.getAllOptions()) {
                    option.configure(parser);
                }
            }
        };
    }

    public PropertiesConverter<T> propertiesConverter() {
        return new PropertiesConverter<T>(){

            @Override
            public T convert(Map<String, String> properties, T target) throws CommandLineArgumentException {
                for (BuildOption option : BuildOptionSet.this.getAllOptions()) {
                    option.applyFromProperty(properties, target);
                }
                return target;
            }
        };
    }

    public PropertiesConverter<T> envVarConverter() {
        return new PropertiesConverter<T>(){

            @Override
            public T convert(Map<String, String> envVars, T target) throws CommandLineArgumentException {
                for (BuildOption option : BuildOptionSet.this.getAllOptions()) {
                    option.applyFromEnvVar(envVars, target);
                }
                return target;
            }
        };
    }
}

