/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.buildconfiguration.tasks.DaemonJvmPropertiesAccessor;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainConfiguration;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.gradle.launcher.daemon.configuration.DaemonPriority;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;
import org.gradle.launcher.daemon.toolchain.ToolchainDownloadUrlProvider;
import org.gradle.process.internal.JvmOptions;
import org.gradle.util.internal.GUtil;

public class DaemonParameters {
    static final int DEFAULT_IDLE_TIMEOUT = 10800000;
    public static final int DEFAULT_PERIODIC_CHECK_INTERVAL_MILLIS = 10000;
    public static final List<String> DEFAULT_JVM_ARGS = ImmutableList.of((Object)"-Xmx512m", (Object)"-Xms256m", (Object)"-XX:MaxMetaspaceSize=384m", (Object)"-XX:+HeapDumpOnOutOfMemoryError");
    private final ToolchainConfiguration toolchainConfiguration;
    private final File gradleUserHomeDir;
    private final JvmOptions jvmOptions;
    private final Map<String, String> envVariables;
    private File baseDir;
    private int idleTimeout = 10800000;
    private int periodicCheckInterval = 10000;
    private boolean applyInstrumentationAgent = true;
    private NativeServices.NativeServicesMode nativeServicesMode = NativeServices.NativeServicesMode.ENABLED;
    private boolean enabled = true;
    private boolean foreground;
    private boolean stop;
    private boolean status;
    private DaemonPriority priority = DaemonPriority.NORMAL;
    private DaemonJvmCriteria requestedJvmCriteria = new DaemonJvmCriteria.LauncherJvm();
    private ToolchainDownloadUrlProvider toolchainDownloadUrlProvider;

    public DaemonParameters(File gradleUserHomeDir, FileCollectionFactory fileCollectionFactory) {
        this(gradleUserHomeDir, fileCollectionFactory, Collections.emptyMap(), new HashMap<String, String>(System.getenv()));
    }

    public DaemonParameters(File gradleUserHomeDir, FileCollectionFactory fileCollectionFactory, Map<String, String> extraSystemProperties, Map<String, String> environmentVariables) {
        this.jvmOptions = new JvmOptions(fileCollectionFactory);
        if (!extraSystemProperties.isEmpty()) {
            this.jvmOptions.systemProperties(extraSystemProperties);
        }
        this.jvmOptions.jvmArgs(DEFAULT_JVM_ARGS);
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.baseDir = new File(gradleUserHomeDir, "daemon");
        this.envVariables = environmentVariables;
        this.toolchainConfiguration = new DefaultToolchainConfiguration(this.envVariables);
    }

    public DaemonRequestContext toRequestContext() {
        return new DaemonRequestContext(this.getRequestedJvmCriteria(), this.getEffectiveJvmArgs(), this.shouldApplyInstrumentationAgent(), this.getNativeServicesMode(), this.getPriority());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getPeriodicCheckInterval() {
        return this.periodicCheckInterval;
    }

    public void setPeriodicCheckInterval(int periodicCheckInterval) {
        this.periodicCheckInterval = periodicCheckInterval;
    }

    public List<String> getEffectiveJvmArgs() {
        return this.jvmOptions.getAllImmutableJvmArgs();
    }

    public DaemonJvmCriteria getRequestedJvmCriteria() {
        return this.requestedJvmCriteria;
    }

    public void setRequestedJvmCriteria(DaemonJvmCriteria requestedJvmCriteria) {
        this.requestedJvmCriteria = requestedJvmCriteria;
    }

    public void setRequestedJvmCriteriaFromMap(Map<String, String> daemonJvmProperties) {
        DaemonJvmPropertiesAccessor daemonJvmAccessor = new DaemonJvmPropertiesAccessor(daemonJvmProperties);
        JavaLanguageVersion requestedVersion = daemonJvmAccessor.getVersion();
        if (requestedVersion != null) {
            JvmVendorSpec requestedJavaVendor = daemonJvmAccessor.getVendor();
            this.requestedJvmCriteria = new DaemonJvmCriteria.Spec(requestedVersion, requestedJavaVendor, JvmImplementation.VENDOR_SPECIFIC, daemonJvmAccessor.getNativeImageCapable());
            this.toolchainDownloadUrlProvider = new ToolchainDownloadUrlProvider(daemonJvmAccessor.getToolchainDownloadUrls());
        }
    }

    public Map<String, String> getSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, (Map)this.jvmOptions.getMutableSystemProperties());
        return systemProperties;
    }

    public Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, (Map)System.getProperties());
        GUtil.addToMap(systemProperties, (Map)this.jvmOptions.getMutableSystemProperties());
        GUtil.addToMap(systemProperties, (Map)this.jvmOptions.getImmutableSystemProperties());
        return systemProperties;
    }

    public Map<String, String> getMutableAndImmutableSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, (Map)this.jvmOptions.getMutableSystemProperties());
        GUtil.addToMap(systemProperties, (Map)this.jvmOptions.getImmutableSystemProperties());
        return systemProperties;
    }

    public void addJvmArgs(Iterable<String> jvmArgs) {
        this.jvmOptions.jvmArgs(jvmArgs);
    }

    public void setJvmArgs(Iterable<String> jvmArgs) {
        this.jvmOptions.setAllJvmArgs(jvmArgs);
    }

    public void setDebug(boolean debug) {
        this.jvmOptions.setDebug(debug);
    }

    public void setDebugPort(int debug) {
        this.jvmOptions.getDebugSpec().setPort(debug);
    }

    public void setDebugHost(String host) {
        this.jvmOptions.getDebugSpec().setHost(host);
    }

    public void setDebugSuspend(boolean suspend) {
        this.jvmOptions.getDebugSpec().setSuspend(suspend);
    }

    public void setDebugServer(boolean server) {
        this.jvmOptions.getDebugSpec().setServer(server);
    }

    public DaemonParameters setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public boolean getDebug() {
        return this.jvmOptions.getDebug();
    }

    public boolean shouldApplyInstrumentationAgent() {
        return this.applyInstrumentationAgent;
    }

    public DaemonParameters setApplyInstrumentationAgent(boolean applyInstrumentationAgent) {
        this.applyInstrumentationAgent = applyInstrumentationAgent;
        return this;
    }

    public NativeServices.NativeServicesMode getNativeServicesMode() {
        return this.nativeServicesMode;
    }

    public DaemonParameters setNativeServicesMode(NativeServices.NativeServicesMode nativeServicesMode) {
        this.nativeServicesMode = nativeServicesMode;
        return this;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public void setForeground(boolean foreground) {
        this.foreground = foreground;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.envVariables;
    }

    public ToolchainConfiguration getToolchainConfiguration() {
        return this.toolchainConfiguration;
    }

    public ToolchainDownloadUrlProvider getToolchainDownloadUrlProvider() {
        return this.toolchainDownloadUrlProvider;
    }

    public DaemonPriority getPriority() {
        return this.priority;
    }

    public void setPriority(DaemonPriority priority) {
        this.priority = priority;
    }
}

