/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import com.google.common.base.Preconditions;
import groovy.lang.Script;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.RemappingScriptSource;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassData;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForLegacy;
import org.gradle.internal.classpath.types.GradleCoreInstrumentationTypeRegistry;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.execution.OutputVisitor;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.instrumentation.reporting.PropertyUpgradeReportConfig;
import org.gradle.internal.scripts.BuildScriptCompilationAndInstrumentation;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

@ServiceScope(value={Scope.Build.class})
public class GroovyScriptClassCompiler
implements ScriptClassCompiler,
Closeable {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String CLASSPATH_PROPERTY_NAME = "classpath";
    private static final String TEMPLATE_ID_PROPERTY_NAME = "templateId";
    private static final String SOURCE_HASH_PROPERTY_NAME = "sourceHash";
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final CachedClasspathTransformer classpathTransformer;
    private final ExecutionEngine earlyExecutionEngine;
    private final FileCollectionFactory fileCollectionFactory;
    private final InputFingerprinter inputFingerprinter;
    private final ImmutableWorkspaceProvider workspaceProvider;
    private final ClasspathElementTransformFactoryForLegacy transformFactoryForLegacy;
    private final GradleCoreInstrumentationTypeRegistry gradleCoreTypeRegistry;
    private final PropertyUpgradeReportConfig propertyUpgradeReportConfig;

    public GroovyScriptClassCompiler(ScriptCompilationHandler scriptCompilationHandler, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, CachedClasspathTransformer classpathTransformer, ExecutionEngine earlyExecutionEngine, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, ImmutableWorkspaceProvider workspaceProvider, ClasspathElementTransformFactoryForLegacy transformFactoryForLegacy, GradleCoreInstrumentationTypeRegistry gradleCoreTypeRegistry, PropertyUpgradeReportConfig propertyUpgradeReportConfig) {
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.classpathTransformer = classpathTransformer;
        this.earlyExecutionEngine = earlyExecutionEngine;
        this.fileCollectionFactory = fileCollectionFactory;
        this.inputFingerprinter = inputFingerprinter;
        this.workspaceProvider = workspaceProvider;
        this.transformFactoryForLegacy = transformFactoryForLegacy;
        this.gradleCoreTypeRegistry = gradleCoreTypeRegistry;
        this.propertyUpgradeReportConfig = propertyUpgradeReportConfig;
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> compile(ScriptSource source, Class<T> scriptBaseClass, Object target, ClassLoaderScope targetScope, CompileOperation<M> operation, Action<? super ClassNode> verifier) {
        assert (source.getResource().isContentCached());
        if (source.getResource().getHasEmptyContent()) {
            return new EmptyCompiledScript(operation);
        }
        String templateId = operation.getId();
        HashCode sourceHashCode = source.getResource().getContentHash();
        RemappingScriptSource remapped = new RemappingScriptSource(source);
        ClassLoader classLoader = targetScope.getExportClassLoader();
        GroovyScriptCompilationAndInstrumentation.GroovyScriptCompilationOutput output = this.doCompile(target, templateId, sourceHashCode, remapped, classLoader, operation, verifier, scriptBaseClass);
        File instrumentedOutput = output.getInstrumentedOutput();
        File metadataDir = output.getMetadataDir();
        ClassPath remappedClasses = this.remapClasses(instrumentedOutput, remapped);
        return this.scriptCompilationHandler.loadFromDir(source, sourceHashCode, targetScope, remappedClasses, metadataDir, operation, scriptBaseClass);
    }

    private <T extends Script> GroovyScriptCompilationAndInstrumentation.GroovyScriptCompilationOutput doCompile(Object target, String templateId, HashCode sourceHashCode, RemappingScriptSource remappedSource, ClassLoader classLoader, CompileOperation<?> operation, Action<? super ClassNode> verifier, Class<T> scriptBaseClass) {
        GroovyScriptCompilationAndInstrumentation unitOfWork = new GroovyScriptCompilationAndInstrumentation(templateId, sourceHashCode, classLoader, remappedSource, operation, verifier, scriptBaseClass, this.classLoaderHierarchyHasher, this.workspaceProvider, this.fileCollectionFactory, this.inputFingerprinter, this.transformFactoryForLegacy, this.scriptCompilationHandler, this.gradleCoreTypeRegistry, this.propertyUpgradeReportConfig);
        return (GroovyScriptCompilationAndInstrumentation.GroovyScriptCompilationOutput)this.getExecutionEngine(target).createRequest((UnitOfWork)unitOfWork).execute().getOutputAs(GroovyScriptCompilationAndInstrumentation.GroovyScriptCompilationOutput.class).get();
    }

    private ExecutionEngine getExecutionEngine(Object target) {
        if (target instanceof ProjectInternal) {
            return (ExecutionEngine)((ProjectInternal)target).getServices().get(ExecutionEngine.class);
        }
        return this.earlyExecutionEngine;
    }

    private ClassPath remapClasses(File genericClassesDir, RemappingScriptSource source) {
        final ScriptSource origin = source.getSource();
        final String className = origin.getClassName();
        return this.classpathTransformer.transform(DefaultClassPath.of((File[])new File[]{genericClassesDir}), new ClassTransform(){

            @Override
            public void applyConfigurationTo(Hasher hasher) {
                hasher.putString((CharSequence)GroovyScriptClassCompiler.class.getSimpleName());
                hasher.putInt(1);
                hasher.putString((CharSequence)className);
            }

            @Override
            public Pair<RelativePath, ClassVisitor> apply(ClasspathEntryVisitor.Entry entry, ClassVisitor visitor, ClassData classData) {
                String renamed = entry.getPath().getLastName();
                if (renamed.startsWith("_BuildScript_")) {
                    renamed = className + renamed.substring("_BuildScript_".length());
                }
                byte[] content = classData.getClassContent();
                ClassReader cr = new ClassReader(content);
                String originalClassName = cr.getClassName();
                String contentHash = Hashing.hashBytes((byte[])content).toString();
                BuildScriptRemapper remapper = new BuildScriptRemapper(visitor, origin, originalClassName, contentHash);
                return Pair.of((Object)entry.getPath().getParent().append(true, new String[]{renamed}), (Object)((Object)remapper));
            }
        });
    }

    @Override
    public void close() {
    }

    private static class EmptyCompiledScript<T extends Script, M>
    implements CompiledScript<T, M> {
        private final M data;

        public EmptyCompiledScript(CompileOperation<M> operation) {
            this.data = operation.getExtractedData();
        }

        @Override
        public boolean getRunDoesSomething() {
            return false;
        }

        @Override
        public boolean getHasMethods() {
            return false;
        }

        @Override
        public void onReuse() {
        }

        @Override
        public Class<? extends T> loadClass() {
            throw new UnsupportedOperationException("Cannot load a script that does nothing.");
        }

        @Override
        public M getData() {
            return this.data;
        }
    }

    static class GroovyScriptCompilationAndInstrumentation
    extends BuildScriptCompilationAndInstrumentation {
        private final String templateId;
        private final HashCode sourceHashCode;
        private final ClassLoader classLoader;
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private final RemappingScriptSource source;
        private final CompileOperation<?> operation;
        private final Class<? extends Script> scriptBaseClass;
        private final ScriptCompilationHandler scriptCompilationHandler;
        private final Action<? super ClassNode> verifier;

        public GroovyScriptCompilationAndInstrumentation(String templateId, HashCode sourceHashCode, ClassLoader classLoader, RemappingScriptSource remappedSource, CompileOperation<?> operation, Action<? super ClassNode> verifier, Class<? extends Script> scriptBaseClass, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ImmutableWorkspaceProvider workspaceProvider, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, ClasspathElementTransformFactoryForLegacy transformFactoryForLegacy, ScriptCompilationHandler scriptCompilationHandler, GradleCoreInstrumentationTypeRegistry gradleCoreTypeRegistry, PropertyUpgradeReportConfig propertyUpgradeReportConfig) {
            super(remappedSource.getSource(), workspaceProvider, fileCollectionFactory, inputFingerprinter, transformFactoryForLegacy, gradleCoreTypeRegistry, propertyUpgradeReportConfig);
            this.templateId = templateId;
            this.sourceHashCode = sourceHashCode;
            this.classLoader = classLoader;
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
            this.source = remappedSource;
            this.operation = operation;
            this.verifier = verifier;
            this.scriptBaseClass = scriptBaseClass;
            this.scriptCompilationHandler = scriptCompilationHandler;
        }

        @Override
        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            return Optional.of(NOT_WORTH_CACHING);
        }

        @Override
        public void visitImmutableInputs(InputVisitor visitor) {
            super.visitImmutableInputs(visitor);
            visitor.visitInputProperty(GroovyScriptClassCompiler.TEMPLATE_ID_PROPERTY_NAME, () -> this.templateId);
            visitor.visitInputProperty(GroovyScriptClassCompiler.SOURCE_HASH_PROPERTY_NAME, () -> this.sourceHashCode);
            visitor.visitInputProperty(GroovyScriptClassCompiler.CLASSPATH_PROPERTY_NAME, () -> this.classLoaderHierarchyHasher.getClassLoaderHash(this.classLoader));
        }

        @Override
        public void visitOutputs(File workspace, OutputVisitor visitor) {
            super.visitOutputs(workspace, visitor);
            File metadataDir = GroovyScriptCompilationAndInstrumentation.metadataDir(workspace);
            OutputVisitor.OutputFileValueSupplier metadataDirValue = OutputVisitor.OutputFileValueSupplier.fromStatic((File)metadataDir, (FileCollection)this.fileCollectionFactory.fixed(new File[]{metadataDir}));
            visitor.visitOutputProperty("metadataDir", TreeType.DIRECTORY, metadataDirValue);
        }

        @Override
        public Object loadAlreadyProducedOutput(File workspace) {
            BuildScriptCompilationAndInstrumentation.Output output = (BuildScriptCompilationAndInstrumentation.Output)super.loadAlreadyProducedOutput(workspace);
            File instrumentedJar = ((BuildScriptCompilationAndInstrumentation.Output)Preconditions.checkNotNull((Object)output)).getInstrumentedOutput();
            File metadataDir = GroovyScriptCompilationAndInstrumentation.metadataDir(workspace);
            return new GroovyScriptCompilationOutput(instrumentedJar, metadataDir);
        }

        @Override
        public File compile(File workspace) {
            File classesDir = this.classesDir(workspace);
            this.scriptCompilationHandler.compileToDir(this.source, this.classLoader, classesDir, GroovyScriptCompilationAndInstrumentation.metadataDir(workspace), this.operation, this.scriptBaseClass, this.verifier);
            return classesDir;
        }

        @Override
        public File instrumentedOutput(File workspace) {
            return new File(workspace, "instrumented/" + this.operation.getId());
        }

        private File classesDir(File workspace) {
            return new File(workspace, "classes/" + this.operation.getId());
        }

        private static File metadataDir(File workspace) {
            return new File(workspace, "metadata");
        }

        @Override
        public String getDisplayName() {
            return "Groovy DSL script compilation (" + this.templateId + ")";
        }

        static class GroovyScriptCompilationOutput {
            private final File instrumentedOutput;
            private final File metadataDir;

            public GroovyScriptCompilationOutput(File instrumentedOutput, File metadataDir) {
                this.instrumentedOutput = instrumentedOutput;
                this.metadataDir = metadataDir;
            }

            public File getInstrumentedOutput() {
                return this.instrumentedOutput;
            }

            public File getMetadataDir() {
                return this.metadataDir;
            }
        }
    }

    private static class BuildScriptRemapper
    extends ClassVisitor
    implements Opcodes {
        private static final String SCRIPT_ORIGIN = "org/gradle/internal/scripts/ScriptOrigin";
        private final ScriptSource scriptSource;
        private final String originalClassName;
        private final String contentHash;

        public BuildScriptRemapper(ClassVisitor cv, ScriptSource source, String originalClassName, String contentHash) {
            super(589824, cv);
            this.scriptSource = source;
            this.originalClassName = originalClassName;
            this.contentHash = contentHash;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String owner = this.remap(name);
            boolean shouldAddScriptOrigin = BuildScriptRemapper.shouldAddScriptOrigin(access);
            this.cv.visit(version, access, owner, this.remap(signature), this.remap(superName), this.remapAndAddInterfaces(interfaces, shouldAddScriptOrigin));
            if (shouldAddScriptOrigin) {
                BuildScriptRemapper.addOriginalClassName(this.cv, owner, this.originalClassName);
                BuildScriptRemapper.addContentHash(this.cv, owner, this.contentHash);
            }
        }

        private static boolean shouldAddScriptOrigin(int access) {
            return (access & 0x200) == 0 && (access & 0x2000) == 0;
        }

        private static void addOriginalClassName(ClassVisitor cv, String owner, String originalClassName) {
            cv.visitField(4122, "__originalClassName", Type.getDescriptor(String.class), "", (Object)originalClassName);
            MethodVisitor mv = cv.visitMethod(1, "getOriginalClassName", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, owner, "__originalClassName", Type.getDescriptor(String.class));
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        private static void addContentHash(ClassVisitor cv, String owner, String contentHash) {
            cv.visitField(4122, "__signature", Type.getDescriptor(String.class), "", (Object)contentHash);
            MethodVisitor mv = cv.visitMethod(1, "getContentHash", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, owner, "__signature", Type.getDescriptor(String.class));
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        public void visitSource(String source, String debug) {
            this.cv.visitSource(this.scriptSource.getFileName(), debug);
        }

        private String[] remapAndAddInterfaces(String[] interfaces, boolean shouldAddScriptOrigin) {
            if (!shouldAddScriptOrigin) {
                return this.remap(interfaces);
            }
            if (interfaces == null) {
                return new String[]{SCRIPT_ORIGIN};
            }
            String[] remapped = new String[interfaces.length + 1];
            for (int i = 0; i < interfaces.length; ++i) {
                remapped[i] = this.remap(interfaces[i]);
            }
            remapped[remapped.length - 1] = SCRIPT_ORIGIN;
            return remapped;
        }

        private String[] remap(String[] names) {
            if (names == null) {
                return null;
            }
            String[] remapped = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                remapped[i] = this.remap(names[i]);
            }
            return remapped;
        }

        private String remap(String name) {
            if (name == null) {
                return null;
            }
            if ("@@sourceuri@@".equals(name)) {
                URI uri = this.scriptSource.getResource().getLocation().getURI();
                return uri == null ? null : uri.toString();
            }
            if ("@@sourcedesc@@".equals(name)) {
                return this.scriptSource.getDisplayName();
            }
            return name.replace("_BuildScript_", this.scriptSource.getClassName());
        }

        private Object remap(Object o) {
            if (o instanceof Type) {
                return Type.getType((String)this.remap(((Type)o).getDescriptor()));
            }
            if (o instanceof String) {
                return this.remap((String)o);
            }
            return o;
        }

        private Object[] remap(int count, Object[] original) {
            if (count == 0) {
                return EMPTY_OBJECT_ARRAY;
            }
            Object[] remapped = new Object[count];
            for (int idx = 0; idx < count; ++idx) {
                remapped[idx] = this.remap(original[idx]);
            }
            return remapped;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, this.remap(desc), this.remap(signature), this.remap(exceptions));
            if (mv != null && (access & 0x400) == 0) {
                mv = new MethodRenamer(mv);
            }
            return mv;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return super.visitField(access, name, this.remap(desc), this.remap(signature), this.remap(value));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(this.remap(name), this.remap(outerName), this.remap(innerName), access);
        }

        public void visitOuterClass(String owner, String name, String desc) {
            super.visitOuterClass(this.remap(owner), this.remap(name), this.remap(desc));
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return super.visitAnnotation(this.remap(desc), visible);
        }

        class MethodRenamer
        extends MethodVisitor {
            public MethodRenamer(MethodVisitor mv) {
                super(589824, mv);
            }

            public void visitTypeInsn(int i, String name) {
                this.mv.visitTypeInsn(i, BuildScriptRemapper.this.remap(name));
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                this.mv.visitFieldInsn(opcode, BuildScriptRemapper.this.remap(owner), name, BuildScriptRemapper.this.remap(desc));
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
                this.mv.visitMethodInsn(opcode, BuildScriptRemapper.this.remap(owner), name, BuildScriptRemapper.this.remap(desc), intf);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                    bootstrapMethodArguments[i] = this.remapIfHandle(bootstrapMethodArguments[i]);
                }
                this.mv.visitInvokeDynamicInsn(BuildScriptRemapper.this.remap(name), BuildScriptRemapper.this.remap(descriptor), this.remapHandle(bootstrapMethodHandle), bootstrapMethodArguments);
            }

            private Object remapIfHandle(Object bootstrapArgument) {
                if (bootstrapArgument instanceof Handle) {
                    Handle handle = (Handle)bootstrapArgument;
                    return this.remapHandle(handle);
                }
                return bootstrapArgument;
            }

            private Handle remapHandle(Handle handle) {
                return new Handle(handle.getTag(), BuildScriptRemapper.this.remap(handle.getOwner()), handle.getName(), BuildScriptRemapper.this.remap(handle.getDesc()), handle.isInterface());
            }

            public void visitLdcInsn(Object cst) {
                super.visitLdcInsn(BuildScriptRemapper.this.remap(cst));
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name, BuildScriptRemapper.this.remap(desc), BuildScriptRemapper.this.remap(signature), start, end, index);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return super.visitAnnotation(BuildScriptRemapper.this.remap(desc), visible);
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                super.visitFrame(type, nLocal, BuildScriptRemapper.this.remap(nLocal, local), nStack, BuildScriptRemapper.this.remap(nStack, stack));
            }
        }
    }
}

