/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PathTraversalChecker {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.US).contains("windows");

    public static String safePathName(String name) {
        if (PathTraversalChecker.isUnsafePathName(name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a safe archive entry or path name.", name));
        }
        return name;
    }

    public static boolean isUnsafePathName(String name) {
        if (name.isEmpty()) {
            return true;
        }
        if (IS_WINDOWS && name.contains(":")) {
            return true;
        }
        if (name.startsWith("/") || name.startsWith("\\")) {
            return true;
        }
        return PathTraversalChecker.containsDirectoryNavigation(name);
    }

    private static String osIndependentPath(String name) {
        if (File.separatorChar == '\\') {
            return name.replace('/', File.separatorChar);
        }
        if (File.separatorChar == '/') {
            return name.replace('\\', File.separatorChar);
        }
        throw new IllegalStateException("Unknown file separator: " + File.separatorChar);
    }

    private static boolean containsDirectoryNavigation(String name) {
        List<String> names = PathTraversalChecker.buildNamesList(name);
        for (String part : names) {
            if (part.equals("..")) {
                return true;
            }
            if (!IS_WINDOWS || part.equals(".") || !part.endsWith(".")) continue;
            return true;
        }
        return false;
    }

    private static List<String> buildNamesList(String name) {
        Path path = new File(PathTraversalChecker.osIndependentPath(name)).toPath();
        ArrayList<String> names = new ArrayList<String>(path.getNameCount());
        for (Path part : path) {
            names.add(part.toString());
        }
        return names;
    }
}

