/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.AssertionFailureDetails;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestMetadataEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestEventReporterInternal;
import org.gradle.api.internal.tasks.testing.TestResultState;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.DefaultTestResult;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestFailureDetails;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class DefaultTestEventReporter
implements TestEventReporterInternal {
    protected final TestListenerInternal listener;
    protected final TestDescriptorInternal testDescriptor;
    protected final TestResultState testResultState;
    private long startTime;

    DefaultTestEventReporter(TestListenerInternal listener, TestDescriptorInternal testDescriptor, TestResultState testResultState) {
        this.listener = listener;
        this.testDescriptor = testDescriptor;
        this.testResultState = testResultState;
    }

    protected boolean isComposite() {
        return false;
    }

    @Override
    public void started(Instant startTime) {
        if (!this.isComposite()) {
            this.testResultState.incrementTotalCount();
        }
        this.startTime = startTime.toEpochMilli();
        this.listener.started(this.testDescriptor, new TestStartEvent(startTime.toEpochMilli(), this.testDescriptor.getParent() == null ? null : this.testDescriptor.getParent().getId()));
    }

    @Override
    public void output(Instant logTime, TestOutputEvent.Destination destination, String output) {
        this.listener.output(this.testDescriptor, (TestOutputEvent)new DefaultTestOutputEvent(logTime.toEpochMilli(), destination, output));
    }

    @Override
    public void metadata(Instant logTime, String key, Object value) {
        Preconditions.checkNotNull((Object)logTime, (Object)"logTime can not be null!");
        Preconditions.checkNotNull((Object)key, (Object)"Metadata key can not be null!");
        Preconditions.checkNotNull((Object)value, (Object)"Metadata value can not be null!");
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(key, value);
        this.listener.metadata(this.testDescriptor, (TestMetadataEvent)new DefaultTestMetadataEvent(logTime.toEpochMilli(), values));
    }

    @Override
    public void metadata(Instant logTime, Map<String, Object> values) {
        Preconditions.checkNotNull((Object)logTime, (Object)"logTime can not be null!");
        Preconditions.checkNotNull(values, (Object)"Metadata can not be null!");
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"Metadata can not be empty!");
        this.listener.metadata(this.testDescriptor, (TestMetadataEvent)new DefaultTestMetadataEvent(logTime.toEpochMilli(), values));
    }

    @Override
    public void succeeded(Instant endTime) {
        if (!this.isComposite()) {
            this.testResultState.incrementSuccessfulCount();
        }
        this.listener.completed(this.testDescriptor, new DefaultTestResult(TestResult.ResultType.SUCCESS, this.startTime, endTime.toEpochMilli(), this.testResultState.getTotalCount(), this.testResultState.getSuccessfulCount(), this.testResultState.getFailureCount(), Collections.emptyList(), null), new TestCompleteEvent(endTime.toEpochMilli(), TestResult.ResultType.SUCCESS));
    }

    @Override
    public void skipped(Instant endTime) {
        this.skipped(endTime, null);
    }

    @Override
    public void skipped(Instant endTime, @Nullable TestFailure assumptionFailure) {
        this.listener.completed(this.testDescriptor, new DefaultTestResult(TestResult.ResultType.SKIPPED, this.startTime, endTime.toEpochMilli(), this.testResultState.getTotalCount(), this.testResultState.getSuccessfulCount(), this.testResultState.getFailureCount(), Collections.emptyList(), assumptionFailure), new TestCompleteEvent(endTime.toEpochMilli(), TestResult.ResultType.SKIPPED));
    }

    @Override
    public void failed(Instant endTime, String message, String additionalContent) {
        AssertionFailureDetails failureDetails = new AssertionFailureDetails(message, Throwable.class.getName(), additionalContent, null, null);
        DefaultTestFailure testFailure = new DefaultTestFailure(new Throwable(message), (TestFailureDetails)failureDetails, Collections.emptyList());
        this.failed(endTime, Collections.singletonList(testFailure));
    }

    @Override
    public void failed(Instant endTime, List<TestFailure> failures) {
        if (!this.isComposite()) {
            this.testResultState.incrementFailureCount();
        }
        this.listener.completed(this.testDescriptor, new DefaultTestResult(TestResult.ResultType.FAILURE, this.startTime, endTime.toEpochMilli(), this.testResultState.getTotalCount(), this.testResultState.getSuccessfulCount(), this.testResultState.getFailureCount(), failures, null), new TestCompleteEvent(endTime.toEpochMilli(), TestResult.ResultType.FAILURE));
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "reporter for " + this.testDescriptor.getDisplayName();
    }
}

