/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.util.internal.GUtil;

public class DefaultComponentSelectorConverter
implements ComponentSelectorConverter {
    private final LocalComponentRegistry localComponentRegistry;

    public DefaultComponentSelectorConverter(LocalComponentRegistry localComponentRegistry) {
        this.localComponentRegistry = localComponentRegistry;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleSelector = (ModuleComponentSelector)selector;
            return DefaultModuleVersionIdentifier.newId(moduleSelector.getModuleIdentifier(), moduleSelector.getVersion());
        }
        if (selector instanceof DefaultProjectComponentSelector) {
            DefaultProjectComponentSelector projectSelector = (DefaultProjectComponentSelector)selector;
            ProjectComponentIdentifier projectId = projectSelector.toIdentifier();
            LocalComponentGraphResolveState projectComponent = this.localComponentRegistry.getComponent(projectId);
            ModuleVersionIdentifier moduleVersionId = projectComponent.getModuleVersionId();
            return DefaultModuleVersionIdentifier.newId(moduleVersionId.getModule(), moduleVersionId.getVersion());
        }
        if (selector instanceof LibraryComponentSelector) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)selector;
            String libraryName = (String)GUtil.elvis((Object)libraryComponentSelector.getLibraryName(), (Object)"");
            return DefaultModuleVersionIdentifier.newId(DefaultModuleIdentifier.newId(libraryComponentSelector.getProjectPath(), libraryName), "undefined");
        }
        throw new IllegalArgumentException("Unrecognized component selector: " + selector);
    }
}

