/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import java.io.File;
import org.gradle.internal.execution.UnitOfWork;
import org.jspecify.annotations.Nullable;

public interface Execution {
    public ExecutionOutcome getOutcome();

    public @Nullable Object getOutput(File var1);

    default public boolean canStoreOutputsInCache() {
        return true;
    }

    public static Execution skipped(final ExecutionOutcome outcome, final UnitOfWork work) {
        return new Execution(){

            @Override
            public ExecutionOutcome getOutcome() {
                return outcome;
            }

            @Override
            public @Nullable Object getOutput(File workspace) {
                return work.loadAlreadyProducedOutput(workspace);
            }
        };
    }

    public static enum ExecutionOutcome {
        UP_TO_DATE,
        FROM_CACHE,
        SHORT_CIRCUITED,
        EXECUTED_INCREMENTALLY,
        EXECUTED_NON_INCREMENTALLY;

    }
}

