/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import java.util.Locale;
import org.gradle.BuildResult;
import org.gradle.api.logging.LogLevel;
import org.gradle.execution.WorkValidationWarningReporter;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.logging.format.DurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.time.Clock;

public class BuildResultLogger {
    private final StyledTextOutputFactory textOutputFactory;
    private final BuildStartedTime buildStartedTime;
    private final DurationFormatter durationFormatter;
    private final WorkValidationWarningReporter workValidationWarningReporter;
    private final Clock clock;

    public BuildResultLogger(StyledTextOutputFactory textOutputFactory, BuildStartedTime buildStartedTime, Clock clock, DurationFormatter durationFormatter, WorkValidationWarningReporter workValidationWarningReporter) {
        this.textOutputFactory = textOutputFactory;
        this.buildStartedTime = buildStartedTime;
        this.clock = clock;
        this.durationFormatter = durationFormatter;
        this.workValidationWarningReporter = workValidationWarningReporter;
    }

    public void buildFinished(BuildResult result) {
        DeprecationLogger.reportSuppressedDeprecations();
        this.workValidationWarningReporter.reportWorkValidationWarningsAtEndOfBuild();
        boolean buildSucceeded = result.getFailure() == null;
        StyledTextOutput textOutput = this.textOutputFactory.create(BuildResultLogger.class, buildSucceeded ? LogLevel.LIFECYCLE : LogLevel.ERROR);
        textOutput.println();
        String action = result.getAction().toUpperCase(Locale.ROOT);
        if (buildSucceeded) {
            textOutput.withStyle(StyledTextOutput.Style.SuccessHeader).text((Object)(action + " SUCCESSFUL"));
        } else {
            textOutput.withStyle(StyledTextOutput.Style.FailureHeader).text((Object)(action + " FAILED"));
        }
        long buildDurationMillis = this.clock.getCurrentTime() - this.buildStartedTime.getStartTime();
        textOutput.formatln(" in %s", new Object[]{this.durationFormatter.format(buildDurationMillis)});
    }
}

