/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootInfo;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputRanges;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class TestTreeModel {
    private static final TestTreeModel EMPTY_MODEL = new TestTreeModel(SmallPath.ROOT, (List<List<PerRootInfo>>)ImmutableList.of(), (List<TestTreeModel>)ImmutableList.of());
    private final SmallPath path;
    private final List<List<PerRootInfo>> perRootInfo;
    private final List<TestTreeModel> children;
    private static final int INDENT_SIZE = 2;

    public static TestTreeModel loadModelFromStores(List<SerializableTestResultStore> stores) throws IOException {
        HashMap<SmallPath, Builder> modelsByPath = new HashMap<SmallPath, Builder>();
        int rootCount = stores.size();
        for (int i = 0; i < rootCount; ++i) {
            SerializableTestResultStore store = stores.get(i);
            store.forEachResult(new StoreLoader(rootCount, i, modelsByPath));
        }
        Builder rootBuilder = (Builder)modelsByPath.get(SmallPath.ROOT);
        if (rootBuilder == null) {
            return EMPTY_MODEL;
        }
        return rootBuilder.build();
    }

    private TestTreeModel(SmallPath path, List<List<PerRootInfo>> perRootInfo, List<TestTreeModel> children) {
        this.path = path;
        this.perRootInfo = perRootInfo;
        this.children = children;
    }

    public Path getPath() {
        return this.path.toPath();
    }

    public List<List<PerRootInfo>> getPerRootInfo() {
        return this.perRootInfo;
    }

    public List<TestTreeModel> getChildren() {
        return this.children;
    }

    public Iterable<TestTreeModel> getChildrenOf(int rootIndex) {
        PerRootInfo perRootInfoWithChildren = this.perRootInfo.get(rootIndex).stream().filter(info -> !info.getChildren().isEmpty()).findFirst().orElse(null);
        if (perRootInfoWithChildren == null) {
            return Collections.emptyList();
        }
        ImmutableSet childNames = ImmutableSet.copyOf(perRootInfoWithChildren.getChildren());
        return Iterables.filter(this.children, c -> childNames.contains((Object)c.path.segment));
    }

    public int getDepth() {
        int deepest = 0;
        for (TestTreeModel treeModel : this.children) {
            int depth = treeModel.getDepth();
            if (depth <= deepest) continue;
            deepest = depth;
        }
        return deepest + 1;
    }

    public void walkDepthFirst(Consumer<TestTreeModel> consumer) {
        consumer.accept(this);
        for (TestTreeModel child : this.children) {
            child.walkDepthFirst(consumer);
        }
    }

    public void dumpStructure(Appendable appendable) {
        this.dumpStructure(appendable, 0);
    }

    private void dumpStructure(Appendable appendable, int indent) {
        try {
            for (int i = 0; i < indent; ++i) {
                appendable.append(' ');
            }
            Path path = this.getPath();
            String name = path.segmentCount() == 0 ? ":" : path.getName();
            appendable.append("- ").append(name).append('\n');
            for (TestTreeModel child : this.children) {
                child.dumpStructure(appendable, indent + 2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to dump test tree structure", e);
        }
    }

    private static final class SmallPath {
        public static final SmallPath ROOT = new SmallPath(null, "");
        private final @Nullable SmallPath parent;
        private final String segment;

        private SmallPath(@Nullable SmallPath parent, String segment) {
            this.parent = parent;
            this.segment = segment;
        }

        public SmallPath child(String segment) {
            return new SmallPath(this, segment);
        }

        public Path toPath() {
            if (this.parent == null) {
                return Path.ROOT;
            }
            return this.parent.toPath().child(this.segment);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SmallPath)) {
                return false;
            }
            SmallPath other = (SmallPath)obj;
            if (!this.segment.equals(other.segment)) {
                return false;
            }
            if (this.parent == null) {
                return other.parent == null;
            }
            return this.parent.equals(other.parent);
        }

        public int hashCode() {
            return Objects.hash(this.segment, this.parent);
        }
    }

    private static final class StoreLoader
    implements SerializableTestResultStore.ResultProcessor {
        private final int rootCount;
        private final int rootIndex;
        private final Map<SmallPath, Builder> modelsByPath;
        private final ListMultimap<Long, Child> childrenByParentId;

        public StoreLoader(int rootCount, int rootIndex, Map<SmallPath, Builder> modelsByPath) {
            this.rootCount = rootCount;
            this.rootIndex = rootIndex;
            this.modelsByPath = modelsByPath;
            this.childrenByParentId = ArrayListMultimap.create();
        }

        @Override
        public void process(long id, @Nullable Long parentId, SerializableTestResult result, OutputRanges outputRanges) throws IOException {
            List children = this.childrenByParentId.get((Object)id);
            int totalLeafCount = 0;
            int failedLeafCount = 0;
            int skippedLeafCount = 0;
            for (Child child : children) {
                totalLeafCount += child.info.getTotalLeafCount();
                failedLeafCount += child.info.getFailedLeafCount();
                skippedLeafCount += child.info.getSkippedLeafCount();
            }
            if (children.isEmpty()) {
                totalLeafCount = 1;
                if (result.getResultType() == TestResult.ResultType.FAILURE) {
                    failedLeafCount = 1;
                } else if (result.getResultType() == TestResult.ResultType.SKIPPED) {
                    skippedLeafCount = 1;
                }
            }
            ArrayList<String> childNames = new ArrayList<String>(children.size());
            BitSet childIsLeaf = new BitSet(children.size());
            for (int i = 0; i < children.size(); ++i) {
                Child child = (Child)children.get(i);
                String name = child.info.getName();
                childNames.add(name);
                if (!child.info.isLeaf()) continue;
                childIsLeaf.set(i);
            }
            PerRootInfo.Builder thisInfo = new PerRootInfo.Builder(id, result, outputRanges, childNames, childIsLeaf, totalLeafCount, failedLeafCount, skippedLeafCount);
            if (parentId == null) {
                this.finalizePath(SmallPath.ROOT, id, thisInfo);
            } else {
                this.childrenByParentId.put((Object)parentId, (Object)new Child(id, thisInfo));
            }
        }

        private void finalizePath(SmallPath path, long id, PerRootInfo.Builder rootInfo) {
            Builder model = this.modelsByPath.computeIfAbsent(path, p -> new Builder(this.rootCount, (SmallPath)p));
            List existingRootInfos = (List)model.perRootInfoBuilders.get(this.rootIndex);
            if (!existingRootInfos.isEmpty()) {
                boolean isLeaf = rootInfo.isLeaf();
                if (isLeaf) {
                    existingRootInfos.add(rootInfo);
                } else {
                    PerRootInfo.Builder toMerge = existingRootInfos.stream().filter(info -> !info.isLeaf()).findFirst().orElseGet(() -> (PerRootInfo.Builder)existingRootInfos.get(0));
                    toMerge.merge(rootInfo);
                }
            } else {
                existingRootInfos.add(rootInfo);
            }
            List children = this.childrenByParentId.get((Object)id);
            for (Child child : children) {
                String name = child.info.getName();
                SmallPath childPath = path.child(name);
                this.finalizePath(childPath, child.id, child.info);
                model.children.computeIfAbsent(name, n -> this.modelsByPath.get(childPath));
            }
        }

        private static final class Child {
            private final long id;
            private final PerRootInfo.Builder info;

            private Child(long id, PerRootInfo.Builder info) {
                this.id = id;
                this.info = info;
            }
        }
    }

    private static final class Builder {
        private final SmallPath path;
        private final List<List<PerRootInfo.Builder>> perRootInfoBuilders;
        final Map<String, Builder> children = new LinkedHashMap<String, Builder>();

        private Builder(int rootCount, SmallPath path) {
            this.perRootInfoBuilders = new ArrayList<List<PerRootInfo.Builder>>(rootCount);
            for (int i = 0; i < rootCount; ++i) {
                this.perRootInfoBuilders.add(new ArrayList());
            }
            this.path = path;
        }

        TestTreeModel build() {
            return new TestTreeModel(this.path, this.buildPerRootInfos(), this.buildChildren());
        }

        private List<List<PerRootInfo>> buildPerRootInfos() {
            ImmutableList.Builder perRootInfosBuilder = ImmutableList.builderWithExpectedSize((int)this.perRootInfoBuilders.size());
            for (int i = 0; i < this.perRootInfoBuilders.size(); ++i) {
                List<PerRootInfo.Builder> builders = this.perRootInfoBuilders.get(i);
                this.perRootInfoBuilders.set(i, (List<PerRootInfo.Builder>)ImmutableList.of());
                ImmutableList.Builder infosBuilder = ImmutableList.builderWithExpectedSize((int)builders.size());
                for (PerRootInfo.Builder builder : builders) {
                    infosBuilder.add((Object)builder.build());
                }
                perRootInfosBuilder.add((Object)infosBuilder.build());
            }
            return perRootInfosBuilder.build();
        }

        private List<TestTreeModel> buildChildren() {
            int size = this.children.size();
            ImmutableList.Builder childrenBuilder = ImmutableList.builderWithExpectedSize((int)size);
            Iterator<Builder> iterator = this.children.values().iterator();
            while (iterator.hasNext()) {
                Builder value = iterator.next();
                iterator.remove();
                childrenBuilder.add((Object)value.build());
            }
            return childrenBuilder.build();
        }
    }
}

