/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class MultiTestReportGenerator
implements TestReportGenerator {
    private final TestReportGenerator primary;
    private final Set<TestReportGenerator> others;

    public MultiTestReportGenerator(TestReportGenerator primary, Set<TestReportGenerator> others) {
        if (others.contains(primary)) {
            throw new IllegalArgumentException("The primary report generator must not be in the set of other report generators.");
        }
        this.primary = primary;
        this.others = others;
    }

    @Override
    public Path generate(List<Path> resultsDirectories) {
        Path primaryReport = this.primary.generate(resultsDirectories);
        for (TestReportGenerator other : this.others) {
            other.generate(resultsDirectories);
        }
        return primaryReport;
    }
}

