/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.ImmutableModuleReplacements;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Describables;
import org.gradle.internal.UncheckedException;

public class DefaultModuleConflictHandler
implements ModuleConflictHandler {
    private static final Logger LOGGER = Logging.getLogger(DefaultModuleConflictHandler.class);
    private final ModuleConflictResolver<ComponentState> resolver;
    private final ConflictContainer<ModuleIdentifier, ComponentState> conflicts = new ConflictContainer();
    private final ImmutableModuleReplacements moduleReplacements;
    private final ResolveState resolveState;

    public DefaultModuleConflictHandler(ModuleConflictResolver<ComponentState> resolver, ImmutableModuleReplacements moduleReplacements, ResolveState resolveState) {
        this.resolver = resolver;
        this.moduleReplacements = moduleReplacements;
        this.resolveState = resolveState;
    }

    @Override
    public ModuleConflictResolver<ComponentState> getResolver() {
        return this.resolver;
    }

    @Override
    public boolean registerCandidate(CandidateModule candidate) {
        ImmutableModuleReplacements.Replacement replacement = this.moduleReplacements.getReplacementFor(candidate.getId());
        ModuleIdentifier replacedBy = replacement == null ? null : replacement.getTarget();
        ConflictContainer.Conflict conflict = this.conflicts.newElement(candidate.getId(), candidate.getVersions(), replacedBy);
        if (conflict != null) {
            for (ModuleIdentifier participant : conflict.participants) {
                this.resolveState.getModule(participant).clearSelection();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @Override
    public boolean hasConflictFor(CandidateModule candidate) {
        return this.conflicts.hasConflictFor(candidate.getId());
    }

    @Override
    public void resolveNextConflict() {
        assert (this.hasConflicts());
        ConflictContainer.Conflict conflict = this.conflicts.popConflict();
        DefaultConflictResolverDetails details = new DefaultConflictResolverDetails(conflict.candidates);
        this.resolver.select(details);
        if (details.hasFailure()) {
            throw UncheckedException.throwAsUncheckedException((Throwable)details.getFailure());
        }
        ComponentState selected = (ComponentState)details.getSelected();
        if (selected == null) {
            throw new IllegalArgumentException("Module conflict resolver " + this.resolver + " did not select any module from " + conflict.candidates);
        }
        ModuleResolveState winningModule = selected.getModule();
        this.resolveState.getModule(winningModule.getId()).replaceWith(selected);
        for (ModuleIdentifier moduleId : conflict.participants) {
            if (moduleId.equals(winningModule.getId())) continue;
            this.resolveState.getModule(moduleId).replaceWith(selected);
        }
        this.maybeSetReason(conflict.participants, (ComponentResolutionState)details.getSelected());
        LOGGER.debug("Selected {} from conflicting modules {}.", details.getSelected(), conflict.candidates);
    }

    private void maybeSetReason(Set<ModuleIdentifier> participants, ComponentResolutionState selected) {
        for (ModuleIdentifier identifier : participants) {
            ImmutableModuleReplacements.Replacement replacement = this.moduleReplacements.getReplacementFor(identifier);
            if (replacement == null) continue;
            String reason = replacement.getReason();
            ComponentSelectionDescriptorInternal moduleReplacement = ComponentSelectionReasons.SELECTED_BY_RULE.withDescription((Describable)Describables.of((Object)identifier, (Object)"replaced with", (Object)replacement.getTarget()));
            if (reason != null) {
                moduleReplacement = moduleReplacement.withDescription((Describable)Describables.of((Object)reason));
            }
            selected.addCause(moduleReplacement);
        }
    }
}

