/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.execution.history.OverlappingOutputDetector;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.jspecify.annotations.Nullable;

public class DefaultOverlappingOutputDetector
implements OverlappingOutputDetector {
    @Override
    public @Nullable OverlappingOutputs detect(ImmutableSortedMap<String, FileSystemSnapshot> previous, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        for (Map.Entry entry : current.entrySet()) {
            OverlappingOutputs overlappingOutputs;
            String propertyName = (String)entry.getKey();
            FileSystemSnapshot currentSnapshot = (FileSystemSnapshot)entry.getValue();
            FileSystemSnapshot previousSnapshot = Objects.requireNonNull((FileSystemSnapshot)previous.getOrDefault((Object)propertyName, (Object)FileSystemSnapshot.EMPTY));
            if (SnapshotUtil.getRootHashes((FileSystemSnapshot)previousSnapshot).equals((Object)SnapshotUtil.getRootHashes((FileSystemSnapshot)currentSnapshot)) || (overlappingOutputs = DefaultOverlappingOutputDetector.detect(propertyName, previousSnapshot, currentSnapshot)) == null) continue;
            return overlappingOutputs;
        }
        return null;
    }

    private static @Nullable OverlappingOutputs detect(String propertyName, FileSystemSnapshot previous, FileSystemSnapshot before) {
        Map previousIndex = SnapshotUtil.indexByRelativePath((FileSystemSnapshot)previous);
        OverlappingOutputsDetectingVisitor outputsDetectingVisitor = new OverlappingOutputsDetectingVisitor(previousIndex);
        before.accept(new RelativePathTracker(), (RelativePathTrackingFileSystemSnapshotHierarchyVisitor)outputsDetectingVisitor);
        String overlappingPath = outputsDetectingVisitor.getOverlappingPath();
        return overlappingPath == null ? null : new OverlappingOutputs(propertyName, overlappingPath);
    }

    private static class OverlappingOutputsDetectingVisitor
    implements RelativePathTrackingFileSystemSnapshotHierarchyVisitor {
        private final Map<String, FileSystemLocationSnapshot> previousSnapshots;
        private @Nullable String overlappingPath;

        public OverlappingOutputsDetectingVisitor(Map<String, FileSystemLocationSnapshot> previousSnapshots) {
            this.previousSnapshots = previousSnapshots;
        }

        public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot, final RelativePathSupplier relativePath) {
            boolean newContent = (Boolean)snapshot.accept((FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer)new FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<Boolean>(){

                public Boolean visitDirectory(DirectorySnapshot directorySnapshot) {
                    return this.hasNewContent(relativePath, (FileSystemLocationSnapshot)directorySnapshot);
                }

                public Boolean visitRegularFile(RegularFileSnapshot fileSnapshot) {
                    return this.hasNewContent(relativePath, (FileSystemLocationSnapshot)fileSnapshot);
                }

                public Boolean visitMissing(MissingFileSnapshot missingSnapshot) {
                    if (relativePath.isRoot()) {
                        return false;
                    }
                    return this.hasNewContent(relativePath, (FileSystemLocationSnapshot)missingSnapshot);
                }
            });
            if (newContent) {
                this.overlappingPath = snapshot.getAbsolutePath();
                return SnapshotVisitResult.TERMINATE;
            }
            return SnapshotVisitResult.CONTINUE;
        }

        private boolean hasNewContent(RelativePathSupplier relativePath, FileSystemLocationSnapshot snapshot) {
            FileSystemLocationSnapshot previousSnapshot = this.previousSnapshots.get(relativePath.toRelativePath());
            if (previousSnapshot == null) {
                return true;
            }
            return !snapshot.isContentUpToDate(previousSnapshot);
        }

        public @Nullable String getOverlappingPath() {
            return this.overlappingPath;
        }
    }
}

