/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilityConflictResolver;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;

public class DefaultCapabilitiesConflictHandler
implements CapabilitiesConflictHandler {
    private final CapabilityConflictResolver resolver;
    private final ResolveState resolveState;
    private final Map<String, ConflictedNodesTracker> capabilityWithoutVersionToTracker = new HashMap<String, ConflictedNodesTracker>();
    private final Deque<String> conflicts = new ArrayDeque<String>();

    public DefaultCapabilitiesConflictHandler(ImmutableList<CapabilitiesResolutionInternal.CapabilityResolutionRule> rules, ResolveState resolveState) {
        this.resolver = new CapabilityConflictResolver(rules);
        this.resolveState = resolveState;
    }

    @Override
    public boolean registerCandidate(NodeState node) {
        ImmutableCapabilities capabilities = node.getMetadata().getCapabilities();
        if (capabilities.isEmpty()) {
            if (node.getComponent().hasMoreThanOneSelectedNodeUsingVariantAwareResolution() || this.hasSeenNonDefaultCapabilityExplicitly((CapabilityInternal)node.getComponent().getImplicitCapability())) {
                ImmutableCapability capability = node.getComponent().getImplicitCapability();
                return this.registerCapability(node, (CapabilityInternal)capability);
            }
            return false;
        }
        boolean defaultCapabilityHasConflict = this.hasSeenNonDefaultCapabilityExplicitly((CapabilityInternal)node.getComponent().getImplicitCapability());
        boolean foundConflict = false;
        for (CapabilityInternal capability : capabilities) {
            if (capability.equals(node.getComponent().getImplicitCapability()) && !defaultCapabilityHasConflict && !node.getComponent().hasMoreThanOneSelectedNodeUsingVariantAwareResolution()) continue;
            foundConflict |= this.registerCapability(node, capability);
        }
        return foundConflict;
    }

    private boolean registerCapability(NodeState node, CapabilityInternal capability) {
        ConflictedNodesTracker tracker = this.capabilityWithoutVersionToTracker.computeIfAbsent(capability.getCapabilityId(), k -> new ConflictedNodesTracker(capability));
        tracker.removeIf(n -> !n.isSelected());
        ModuleResolveState module = this.resolveState.findModule(DefaultModuleIdentifier.newId(capability.getGroup(), capability.getName()));
        if (module != null) {
            for (ComponentState componentState : module.getVersions()) {
                for (NodeState potentialNode : componentState.getNodes()) {
                    if (node == potentialNode || !potentialNode.isSelected() || !potentialNode.getMetadata().getCapabilities().isEmpty()) continue;
                    tracker.add(potentialNode);
                }
            }
        }
        if (tracker.add(node) && tracker.hasConflictedNodes()) {
            ModuleIdentifier rootId = null;
            for (NodeState ns : tracker) {
                if (!ns.isRoot()) continue;
                rootId = ns.getComponent().getModule().getId();
            }
            Set set = tracker.getConflictedNodesCopy();
            if (rootId != null && set.size() > 1) {
                ModuleIdentifier rootModuleId = rootId;
                set.removeIf(n -> !n.isRoot() && n.getComponent().getModule().getId().equals(rootModuleId));
            }
            if (set.size() > 1 && !set.stream().allMatch(n -> n.getComponent().isRejected())) {
                if (tracker.createOrUpdateConflict(set)) {
                    this.conflicts.add(tracker.capabilityId);
                }
                for (NodeState candidateNode : set) {
                    candidateNode.getComponent().getModule().clearSelection();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @Override
    public boolean hasConflictFor(NodeState node) {
        for (ConflictedNodesTracker tracker : this.capabilityWithoutVersionToTracker.values()) {
            for (NodeState conflictedNode : tracker) {
                if (conflictedNode != node) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void resolveNextConflict() {
        String capabilityInConflict = this.conflicts.remove();
        ConflictedNodesTracker conflictTracker = this.capabilityWithoutVersionToTracker.get(capabilityInConflict);
        CapabilityConflict conflict = conflictTracker.updateClearAndReturnConflict();
        if (!conflict.isValidConflict()) {
            return;
        }
        this.resolver.resolve(conflict.group, conflict.name, conflict.nodes);
    }

    private boolean hasSeenNonDefaultCapabilityExplicitly(CapabilityInternal capability) {
        return this.capabilityWithoutVersionToTracker.containsKey(capability.getCapabilityId());
    }

    private static class ConflictedNodesTracker
    implements Iterable<NodeState> {
        private final String group;
        private final String name;
        private final String capabilityId;
        private final List<Set<NodeState>> previousConflictedNodes = new ArrayList<Set<NodeState>>();
        private Set<NodeState> currentConflictedNodes = new LinkedHashSet<NodeState>();
        private CapabilityConflict pendingConflict;

        private ConflictedNodesTracker(CapabilityInternal capability) {
            this.group = capability.getGroup();
            this.name = capability.getName();
            this.capabilityId = capability.getCapabilityId();
        }

        private CapabilityConflict updateClearAndReturnConflict() {
            CapabilityConflict currentConflict = this.pendingConflict;
            this.pendingConflict = null;
            LinkedHashSet<NodeState> selectedNodes = new LinkedHashSet<NodeState>();
            boolean didFilter = false;
            for (NodeState node : currentConflict.nodes) {
                if (node.isSelected() || !currentConflict.nodeToDependentNodes.isEmpty() && currentConflict.nodeToDependentNodes.getOrDefault(node, Collections.emptySet()).stream().anyMatch(NodeState::isSelected)) {
                    selectedNodes.add(node);
                    continue;
                }
                didFilter = true;
            }
            if (didFilter) {
                this.previousConflictedNodes.add(this.currentConflictedNodes);
                this.currentConflictedNodes = selectedNodes;
                return currentConflict.withDifferentNodes(selectedNodes);
            }
            return currentConflict;
        }

        private boolean removeIf(Predicate<? super NodeState> pre) {
            return this.currentConflictedNodes.removeIf(pre);
        }

        private boolean add(NodeState node) {
            return this.currentConflictedNodes.add(node);
        }

        @Override
        public Iterator<NodeState> iterator() {
            return this.currentConflictedNodes.iterator();
        }

        private boolean hasConflictedNodes() {
            return this.currentConflictedNodes.size() > 1;
        }

        private Set<NodeState> getConflictedNodesCopy() {
            return new LinkedHashSet<NodeState>(this.currentConflictedNodes);
        }

        private boolean createOrUpdateConflict(Set<NodeState> candidatesForConflict) {
            boolean newConflict = this.pendingConflict == null;
            this.pendingConflict = new CapabilityConflict(this.group, this.name, candidatesForConflict, this.previousConflictedNodes.contains(candidatesForConflict));
            return newConflict;
        }
    }

    private static class CapabilityConflict {
        private final String group;
        private final String name;
        private final Set<NodeState> nodes;
        private final Map<NodeState, Set<NodeState>> nodeToDependentNodes;

        private CapabilityConflict(String group, String name, Set<NodeState> nodes, boolean alreadySeen) {
            this(group, name, nodes, alreadySeen ? CapabilityConflict.buildDependentRelationships(nodes) : Collections.emptyMap());
        }

        private CapabilityConflict(String group, String name, Set<NodeState> nodes, Map<NodeState, Set<NodeState>> nodeToDependentNodes) {
            this.group = group;
            this.name = name;
            this.nodes = nodes;
            this.nodeToDependentNodes = nodeToDependentNodes;
        }

        private CapabilityConflict withDifferentNodes(Set<NodeState> selectedNodes) {
            return new CapabilityConflict(this.group, this.name, selectedNodes, this.nodeToDependentNodes);
        }

        private boolean isValidConflict() {
            return !this.nodes.isEmpty() && this.nodes.stream().anyMatch(node -> !node.getComponent().isRejected());
        }

        private static Map<NodeState, Set<NodeState>> buildDependentRelationships(Set<NodeState> nodes) {
            HashMap<NodeState, Set<NodeState>> nodeToDependents = new HashMap<NodeState, Set<NodeState>>();
            for (NodeState node : nodes) {
                Set<NodeState> reachableNodes = node.getReachableNodes();
                for (NodeState possibleDependency : nodes) {
                    if (node == possibleDependency || !reachableNodes.contains(possibleDependency)) continue;
                    nodeToDependents.computeIfAbsent(possibleDependency, k -> new HashSet()).add(node);
                }
            }
            return nodeToDependents;
        }
    }
}

