/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.publish.internal.metadata.JsonWriterScope;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpec;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.Nullable;

class ModuleMetadataJsonWriter
extends JsonWriterScope {
    private final ModuleMetadataSpec metadata;
    private final @Nullable String buildId;
    private final ChecksumService checksumService;

    public ModuleMetadataJsonWriter(JsonWriter jsonWriter, ModuleMetadataSpec metadata, @Nullable String buildId, ChecksumService checksumService) {
        super(jsonWriter);
        this.metadata = metadata;
        this.buildId = buildId;
        this.checksumService = checksumService;
    }

    void write() throws IOException {
        this.writeObject(() -> {
            this.writeFormat();
            this.writeIdentity();
            this.writeCreator();
            this.writeVariants();
        });
    }

    private void writeFormat() throws IOException {
        this.write("formatVersion", "1.1");
    }

    private void writeIdentity() throws IOException {
        this.writeObject("component", () -> {
            ModuleMetadataSpec.Identity identity = this.metadata.identity;
            if (identity.relativeUrl != null) {
                this.write("url", identity.relativeUrl);
            }
            this.writeCoordinates(identity.coordinates);
            this.writeAttributes(identity.attributes);
        });
    }

    private void writeCreator() throws IOException {
        this.writeObject("createdBy", () -> this.writeObject("gradle", () -> {
            this.write("version", GradleVersion.current().getVersion());
            if (this.buildId != null) {
                this.write("buildId", this.buildId);
            }
        }));
    }

    private void writeVariants() throws IOException {
        List<ModuleMetadataSpec.Variant> variants = this.metadata.variants;
        if (variants.isEmpty()) {
            return;
        }
        this.writeArray("variants", () -> {
            for (ModuleMetadataSpec.Variant variant : variants) {
                if (variant instanceof ModuleMetadataSpec.LocalVariant) {
                    ModuleMetadataSpec.LocalVariant local = (ModuleMetadataSpec.LocalVariant)variant;
                    this.writeObject(() -> {
                        this.write("name", local.name);
                        this.writeAttributes(local.attributes);
                        this.writeDependencies(local.dependencies);
                        this.writeDependencyConstraints(local.dependencyConstraints);
                        this.writeArtifacts(local.artifacts);
                        this.writeCapabilities("capabilities", local.capabilities);
                    });
                    continue;
                }
                if (variant instanceof ModuleMetadataSpec.RemoteVariant) {
                    ModuleMetadataSpec.RemoteVariant remote = (ModuleMetadataSpec.RemoteVariant)variant;
                    this.writeObject(() -> {
                        this.write("name", remote.name);
                        this.writeAttributes(remote.attributes);
                        this.writeAvailableAt(remote.availableAt);
                        this.writeCapabilities("capabilities", remote.capabilities);
                    });
                    continue;
                }
                throw new IllegalStateException("Unknown variant type: " + variant);
            }
        });
    }

    private void writeNonEmptyAttributes(List<ModuleMetadataSpec.Attribute> attributes) throws IOException {
        if (!attributes.isEmpty()) {
            this.writeAttributes(attributes);
        }
    }

    private void writeAttributes(List<ModuleMetadataSpec.Attribute> attributes) throws IOException {
        this.writeObject("attributes", () -> {
            for (ModuleMetadataSpec.Attribute attribute : attributes) {
                this.writeAttribute(attribute.name, attribute.value);
            }
        });
    }

    private void writeAttribute(String name, Object value) throws IOException {
        if (value instanceof Boolean) {
            this.write(name, (Boolean)value);
        } else if (value instanceof Integer) {
            this.write(name, (Integer)value);
        } else if (value instanceof String) {
            this.write(name, (String)value);
        } else {
            throw new IllegalArgumentException("value");
        }
    }

    private void writeCapabilities(String key, List<ModuleMetadataSpec.Capability> capabilities) throws IOException {
        if (capabilities.isEmpty()) {
            return;
        }
        this.writeArray(key, () -> {
            for (ModuleMetadataSpec.Capability capability : capabilities) {
                this.writeObject(() -> {
                    this.write("group", capability.group);
                    this.write("name", capability.name);
                    if (capability.version != null) {
                        this.write("version", capability.version);
                    }
                });
            }
        });
    }

    private void writeAvailableAt(ModuleMetadataSpec.AvailableAt availableAt) throws IOException {
        this.writeObject("available-at", () -> {
            this.write("url", availableAt.url);
            this.writeCoordinates(availableAt.coordinates);
        });
    }

    private void writeCoordinates(ModuleVersionIdentifier coordinates) throws IOException {
        this.write("group", coordinates.getGroup());
        this.write("module", coordinates.getName());
        this.write("version", coordinates.getVersion());
    }

    private void writeArtifacts(List<ModuleMetadataSpec.Artifact> artifacts) throws IOException {
        if (artifacts.isEmpty()) {
            return;
        }
        this.writeArray("files", () -> {
            for (ModuleMetadataSpec.Artifact artifact : artifacts) {
                this.writeObject(() -> {
                    this.write("name", artifact.name);
                    this.write("url", artifact.uri);
                    File file = artifact.file;
                    this.write("size", file.length());
                    this.write("sha512", this.sha512(file));
                    this.write("sha256", this.sha256(file));
                    this.write("sha1", this.sha1(file));
                    this.write("md5", this.md5(file));
                });
            }
        });
    }

    private void writeDependencies(List<ModuleMetadataSpec.Dependency> dependencies) throws IOException {
        if (dependencies.isEmpty()) {
            return;
        }
        this.writeArray("dependencies", () -> {
            for (ModuleMetadataSpec.Dependency moduleDependency : dependencies) {
                this.writeObject(() -> {
                    ModuleMetadataSpec.DependencyCoordinates identifier = moduleDependency.coordinates;
                    this.write("group", identifier.group);
                    this.write("module", identifier.name);
                    this.writeVersionConstraint(identifier.version);
                    this.writeExcludes(moduleDependency.excludeRules);
                    this.writeNonEmptyAttributes(moduleDependency.attributes);
                    this.writeCapabilities("requestedCapabilities", moduleDependency.requestedCapabilities);
                    if (moduleDependency.endorseStrictVersions) {
                        this.write("endorseStrictVersions", true);
                    }
                    if (moduleDependency.reason != null) {
                        this.write("reason", moduleDependency.reason);
                    }
                    if (moduleDependency.artifactSelector != null) {
                        this.writeDependencyArtifact(moduleDependency.artifactSelector);
                    }
                });
            }
        });
    }

    private void writeVersionConstraint(@Nullable ModuleMetadataSpec.Version version) throws IOException {
        if (version == null) {
            return;
        }
        this.writeObject("version", () -> {
            if (version.strictly != null) {
                this.write("strictly", version.strictly);
            }
            if (version.requires != null) {
                this.write("requires", version.requires);
            }
            if (version.preferred != null) {
                this.write("prefers", version.preferred);
            }
            if (!version.rejectedVersions.isEmpty()) {
                this.writeArray("rejects", version.rejectedVersions);
            }
        });
    }

    private void writeDependencyArtifact(ModuleMetadataSpec.ArtifactSelector artifactSelector) throws IOException {
        this.writeObject("thirdPartyCompatibility", () -> this.writeObject("artifactSelector", () -> {
            this.write("name", artifactSelector.name);
            this.write("type", artifactSelector.type);
            if (artifactSelector.extension != null) {
                this.write("extension", artifactSelector.extension);
            }
            if (artifactSelector.classifier != null) {
                this.write("classifier", artifactSelector.classifier);
            }
        }));
    }

    private void writeDependencyConstraints(List<ModuleMetadataSpec.DependencyConstraint> constraints) throws IOException {
        if (constraints.isEmpty()) {
            return;
        }
        this.writeArray("dependencyConstraints", () -> {
            for (ModuleMetadataSpec.DependencyConstraint constraint : constraints) {
                this.writeObject(() -> {
                    this.write("group", constraint.coordinates.group);
                    this.write("module", constraint.coordinates.name);
                    this.writeVersionConstraint(constraint.coordinates.version);
                    this.writeNonEmptyAttributes(constraint.attributes);
                    if (constraint.reason != null) {
                        this.write("reason", constraint.reason);
                    }
                });
            }
        });
    }

    private void writeExcludes(Set<ExcludeRule> excludeRules) throws IOException {
        if (excludeRules.isEmpty()) {
            return;
        }
        this.writeArray("excludes", () -> {
            for (ExcludeRule excludeRule : excludeRules) {
                this.writeObject(() -> {
                    this.write("group", (String)GUtil.elvis((Object)excludeRule.getGroup(), (Object)"*"));
                    this.write("module", (String)GUtil.elvis((Object)excludeRule.getModule(), (Object)"*"));
                });
            }
        });
    }

    private String md5(File file) {
        return this.checksumService.md5(file).toString();
    }

    private String sha1(File file) {
        return this.checksumService.sha1(file).toString();
    }

    private String sha256(File file) {
        return this.checksumService.sha256(file).toString();
    }

    private String sha512(File file) {
        return this.checksumService.sha512(file).toString();
    }
}

