/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.testing.toolchains.internal;

import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.testing.toolchains.internal.JUnitPlatformToolchainParameters;
import org.gradle.api.testing.toolchains.internal.JvmTestToolchain;

public abstract class JUnitPlatformTestToolchain<T extends JUnitPlatformToolchainParameters>
implements JvmTestToolchain<T> {
    public static final String DEFAULT_VERSION = "1.10.0";
    private static final String GROUP_NAME = "org.junit.platform:junit-platform-launcher";

    @Inject
    protected abstract DependencyFactory getDependencyFactory();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Override
    public TestFramework createTestFramework(Test task) {
        return (TestFramework)this.getObjectFactory().newInstance(JUnitPlatformTestFramework.class, new Object[]{task.getFilter(), task.getDryRun(), task.getWorkingDir()});
    }

    @Override
    public Iterable<Dependency> getRuntimeOnlyDependencies() {
        return ImmutableSet.of((Object)this.getDependencyFactory().create((CharSequence)(GROUP_NAME + (String)((JUnitPlatformToolchainParameters)this.getParameters()).getPlatformVersion().map(version -> ":" + version).getOrElse((Object)""))));
    }
}

