/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;

public class MergeConfig {
    private final MergeCommand.FastForwardMode fastForwardMode;
    private final boolean squash;
    private final boolean commit;

    public static MergeConfig getConfigForCurrentBranch(Repository repo) {
        try {
            String branch = repo.getBranch();
            if (branch != null) {
                return repo.getConfig().get(MergeConfig.getParser(branch));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new MergeConfig();
    }

    public static final Config.SectionParser<MergeConfig> getParser(String branch) {
        return new MergeConfigSectionParser(branch);
    }

    private MergeConfig(String branch, Config config) {
        String[] mergeOptions = MergeConfig.getMergeOptions(branch, config);
        this.fastForwardMode = MergeConfig.getFastForwardMode(config, mergeOptions);
        this.squash = MergeConfig.isMergeConfigOptionSet("--squash", mergeOptions);
        this.commit = !MergeConfig.isMergeConfigOptionSet("--no-commit", mergeOptions);
    }

    private MergeConfig() {
        this.fastForwardMode = MergeCommand.FastForwardMode.FF;
        this.squash = false;
        this.commit = true;
    }

    public MergeCommand.FastForwardMode getFastForwardMode() {
        return this.fastForwardMode;
    }

    public boolean isSquash() {
        return this.squash;
    }

    public boolean isCommit() {
        return this.commit;
    }

    private static MergeCommand.FastForwardMode getFastForwardMode(Config config, String[] mergeOptions) {
        String[] stringArray = mergeOptions;
        int n = mergeOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            MergeCommand.FastForwardMode[] fastForwardModeArray = MergeCommand.FastForwardMode.values();
            int n3 = fastForwardModeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MergeCommand.FastForwardMode mode = fastForwardModeArray[n4];
                if (mode.matchConfigValue(option)) {
                    return mode;
                }
                ++n4;
            }
            ++n2;
        }
        MergeCommand.FastForwardMode ffmode = MergeCommand.FastForwardMode.valueOf(config.getEnum("merge", null, "ff", MergeCommand.FastForwardMode.Merge.TRUE));
        return ffmode;
    }

    private static boolean isMergeConfigOptionSet(String optionToLookFor, String[] mergeOptions) {
        String[] stringArray = mergeOptions;
        int n = mergeOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (optionToLookFor.equals(option)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String[] getMergeOptions(String branch, Config config) {
        String mergeOptions = config.getString("branch", branch, "mergeoptions");
        if (mergeOptions != null) {
            return mergeOptions.split("\\s");
        }
        return new String[0];
    }

    private static class MergeConfigSectionParser
    implements Config.SectionParser<MergeConfig> {
        private final String branch;

        public MergeConfigSectionParser(String branch) {
            this.branch = branch;
        }

        @Override
        public MergeConfig parse(Config cfg) {
            return new MergeConfig(this.branch, cfg);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MergeConfigSectionParser) {
                return this.branch.equals(((MergeConfigSectionParser)obj).branch);
            }
            return false;
        }

        public int hashCode() {
            return this.branch.hashCode();
        }
    }
}

