/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.LongPredicate;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.io.IoConsumer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;

public final class TestOutputReader
implements Closeable {
    private final Path outputEventsFile;
    private final Serializer<TestOutputEvent> testOutputEventSerializer;
    private final BlockingQueue<SeekableByteChannel> channelPool = new LinkedBlockingQueue<SeekableByteChannel>(64);

    TestOutputReader(Path outputEventsFile, Serializer<TestOutputEvent> testOutputEventSerializer) {
        this.outputEventsFile = outputEventsFile;
        this.testOutputEventSerializer = testOutputEventSerializer;
    }

    public boolean hasOutput(OutputEntry entry, TestOutputEvent.Destination destination) {
        switch (destination) {
            case StdOut: {
                return entry.startStdout != -1L;
            }
            case StdErr: {
                return entry.startStderr != -1L;
            }
        }
        throw new IllegalArgumentException("Unknown destination: " + destination);
    }

    public void useTestOutputEvents(OutputEntry entry, TestOutputEvent.Destination destination, IoConsumer<TestOutputEvent> eventConsumer) throws IOException {
        long entryStart = TestOutputReader.getStart(destination, entry);
        if (entryStart == -1L) {
            return;
        }
        this.useTestOutputEventsWithInfo(destination, eventConsumer, entryStart, entry.end, id -> entry.id == id);
    }

    public void useTestOutputEvents(Iterable<OutputEntry> entries, TestOutputEvent.Destination destination, IoConsumer<TestOutputEvent> eventConsumer) throws IOException {
        CombinedEntryInfo info = TestOutputReader.getCombinedEntryInfo(entries, destination);
        if (info.start == -1L) {
            return;
        }
        ImmutableSet ids = info.idsBuilder.build();
        this.useTestOutputEventsWithInfo(destination, eventConsumer, info.start, info.end, arg_0 -> ((ImmutableSet)ids).contains(arg_0));
    }

    private static CombinedEntryInfo getCombinedEntryInfo(Iterable<OutputEntry> entries, TestOutputEvent.Destination destination) {
        CombinedEntryInfo info = new CombinedEntryInfo();
        for (OutputEntry entry : entries) {
            long entryStart = TestOutputReader.getStart(destination, entry);
            if (entryStart == -1L) continue;
            if (info.start == -1L || entryStart < info.start) {
                info.start = entryStart;
            }
            if (info.end == -1L || entry.end > info.end) {
                info.end = entry.end;
            }
            info.idsBuilder.add((Object)entry.id);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useTestOutputEventsWithInfo(TestOutputEvent.Destination destination, IoConsumer<TestOutputEvent> eventConsumer, long start, long end, LongPredicate matchesId) throws IOException {
        SeekableByteChannel channel = this.requestChannel();
        try {
            channel.position(start);
            InputStream stream = ByteStreams.limit((InputStream)Channels.newInputStream(channel), (long)(end - start));
            KryoBackedDecoder decoder = new KryoBackedDecoder(stream);
            this.iterateEvents((Decoder)decoder, matchesId, destination, eventConsumer);
        }
        finally {
            this.returnChannel(channel);
        }
    }

    private static long getStart(TestOutputEvent.Destination destination, OutputEntry entry) {
        switch (destination) {
            case StdOut: {
                return entry.startStdout;
            }
            case StdErr: {
                return entry.startStderr;
            }
        }
        throw new IllegalArgumentException("Unknown destination: " + destination);
    }

    private void iterateEvents(Decoder decoder, LongPredicate matchesId, TestOutputEvent.Destination destination, IoConsumer<TestOutputEvent> eventConsumer) throws IOException {
        while (true) {
            TestOutputEvent event;
            long id;
            try {
                id = decoder.readLong();
            }
            catch (EOFException e) {
                break;
            }
            try {
                event = (TestOutputEvent)this.testOutputEventSerializer.read(decoder);
            }
            catch (EOFException e) {
                throw new IllegalStateException("Should have reached EOF when reading the id, not in the middle of an event", e);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            if (!matchesId.test(id) || event.getDestination() != destination) continue;
            eventConsumer.accept((Object)event);
        }
    }

    private SeekableByteChannel requestChannel() {
        SeekableByteChannel open = (SeekableByteChannel)this.channelPool.poll();
        if (open != null && open.isOpen()) {
            return open;
        }
        try {
            return Files.newByteChannel(this.outputEventsFile, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open output events file: " + this.outputEventsFile, e);
        }
    }

    private void returnChannel(SeekableByteChannel channel) {
        boolean added;
        try {
            added = this.channelPool.offer(channel);
        }
        catch (Throwable t) {
            try {
                channel.close();
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            throw t;
        }
        if (!added) {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable(this.channelPool).stop();
    }

    private static final class CombinedEntryInfo {
        long start = -1L;
        long end = -1L;
        final ImmutableSet.Builder<Long> idsBuilder = ImmutableSet.builder();

        private CombinedEntryInfo() {
        }
    }
}

