/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AdhocHandlingComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DeduplicatingAttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DeduplicatingComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DependencyResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedDependencyGraph;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.cache.internal.Store;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class StreamingResolutionResultBuilder
implements DependencyGraphVisitor {
    private static final byte ROOT = 1;
    private static final byte COMPONENT = 2;
    private static final byte NODE_DEPENDENCIES = 5;
    private final Map<ComponentSelector, ModuleVersionResolveException> failures = new HashMap<ComponentSelector, ModuleVersionResolveException>();
    private final BinaryStore store;
    private final AdhocHandlingComponentResultSerializer componentResultSerializer;
    private final Store<ResolvedDependencyGraph> cache;
    private final boolean includeAllSelectableVariantResults;
    private final Factory<DependencyResultSerializer> dependencyResultSerializerFactory;
    private final DependencyResultSerializer dependencyResultSerializer;
    private final Set<Long> visitedComponents = new HashSet<Long>();
    private ImmutableAttributes rootAttributes;
    private boolean mayHaveVirtualPlatforms;

    public StreamingResolutionResultBuilder(BinaryStore store, Store<ResolvedDependencyGraph> cache, AttributeContainerSerializer attributeContainerSerializer, CapabilitySelectorSerializer capabilitySelectorSerializer, AdhocHandlingComponentResultSerializer componentResultSerializer, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, boolean includeAllSelectableVariantResults) {
        this.store = store;
        this.cache = cache;
        this.componentResultSerializer = componentResultSerializer;
        this.includeAllSelectableVariantResults = includeAllSelectableVariantResults;
        this.dependencyResultSerializerFactory = () -> new DependencyResultSerializer(new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory), new DeduplicatingComponentSelectorSerializer(new ComponentSelectorSerializer(new DeduplicatingAttributeContainerSerializer(attributeContainerSerializer), capabilitySelectorSerializer)));
        this.dependencyResultSerializer = (DependencyResultSerializer)this.dependencyResultSerializerFactory.create();
    }

    public MinimalResolutionResult getResolutionResult(Set<UnresolvedDependency> dependencyLockingFailures) {
        BinaryStore.BinaryData data = this.store.done();
        GraphFactory graphSource = new GraphFactory(data, this.failures, this.cache, this.dependencyResultSerializerFactory, this.componentResultSerializer, dependencyLockingFailures);
        return new MinimalResolutionResult(graphSource::create, this.rootAttributes);
    }

    @Override
    public void start(RootGraphNode root) {
        this.rootAttributes = root.getMetadata().getAttributes();
        this.mayHaveVirtualPlatforms = root.getResolveOptimizations().mayHaveVirtualPlatforms();
    }

    @Override
    public void finish(RootGraphNode root) {
        this.store.write(encoder -> {
            encoder.writeByte((byte)1);
            encoder.writeSmallLong(root.getNodeId());
            encoder.writeSmallLong(root.getOwner().getResultId());
        });
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent component = node.getOwner();
        if (this.visitedComponents.add(component.getResultId())) {
            this.store.write(encoder -> {
                encoder.writeByte((byte)2);
                this.componentResultSerializer.writeComponentResult(encoder, component, this.includeAllSelectableVariantResults);
            });
        }
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        Collection dependencies;
        Collection collection = dependencies = this.mayHaveVirtualPlatforms ? (Collection)node.getOutgoingEdges().stream().filter(dep -> !dep.isTargetVirtualPlatform()).collect(Collectors.toList()) : node.getOutgoingEdges();
        if (!dependencies.isEmpty()) {
            this.store.write(encoder -> {
                encoder.writeByte((byte)5);
                encoder.writeSmallLong(node.getNodeId());
                encoder.writeSmallLong(node.getOwner().getResultId());
                encoder.writeSmallInt(dependencies.size());
                for (DependencyGraphEdge dependency : dependencies) {
                    this.dependencyResultSerializer.write(encoder, dependency);
                    if (dependency.getFailure() == null) continue;
                    this.failures.put(dependency.getRequested(), dependency.getFailure());
                }
            });
        }
    }

    private static class GraphFactory
    implements Factory<ResolvedDependencyGraph> {
        private static final Logger LOG = Logging.getLogger(GraphFactory.class);
        private final AdhocHandlingComponentResultSerializer componentResultSerializer;
        private final BinaryStore.BinaryData data;
        private final Map<ComponentSelector, ModuleVersionResolveException> failures;
        private final Store<ResolvedDependencyGraph> cache;
        private final Object lock = new Object();
        private final Factory<DependencyResultSerializer> dependencyResultSerializerFactory;
        private final Set<UnresolvedDependency> dependencyLockingFailures;

        GraphFactory(BinaryStore.BinaryData data, Map<ComponentSelector, ModuleVersionResolveException> failures, Store<ResolvedDependencyGraph> cache, Factory<DependencyResultSerializer> dependencyResultSerializerFactory, AdhocHandlingComponentResultSerializer componentResultSerializer, Set<UnresolvedDependency> dependencyLockingFailures) {
            this.data = data;
            this.failures = failures;
            this.cache = cache;
            this.componentResultSerializer = componentResultSerializer;
            this.dependencyResultSerializerFactory = dependencyResultSerializerFactory;
            this.dependencyLockingFailures = dependencyLockingFailures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResolvedDependencyGraph create() {
            Object object = this.lock;
            synchronized (object) {
                return (ResolvedDependencyGraph)this.cache.load(() -> {
                    try {
                        ResolvedDependencyGraph resolvedDependencyGraph = (ResolvedDependencyGraph)this.data.read(this::deserialize);
                        return resolvedDependencyGraph;
                    }
                    finally {
                        try {
                            this.data.close();
                        }
                        catch (IOException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                    }
                });
            }
        }

        private ResolvedDependencyGraph deserialize(Decoder decoder) {
            DependencyResultSerializer dependencyResultSerializer = (DependencyResultSerializer)this.dependencyResultSerializerFactory.create();
            int valuesRead = 0;
            int type = -1;
            Timer clock = Time.startTimer();
            try {
                ResolutionResultGraphBuilder builder = new ResolutionResultGraphBuilder();
                block7: while (true) {
                    type = decoder.readByte();
                    ++valuesRead;
                    switch (type) {
                        case 1: {
                            long rootVariantId = decoder.readSmallLong();
                            long rootComponentId = decoder.readSmallLong();
                            builder.addDependencyLockingFailures(rootComponentId, rootVariantId, this.dependencyLockingFailures);
                            ResolvedDependencyGraph graph = builder.getResolvedGraph(rootComponentId, rootVariantId);
                            LOG.debug("Loaded resolution results ({}) from {}", (Object)clock.getElapsed(), (Object)this.data);
                            return graph;
                        }
                        case 2: {
                            this.componentResultSerializer.readComponentResult(decoder, builder);
                            continue block7;
                        }
                        case 5: {
                            long fromVariantId = decoder.readSmallLong();
                            long fromComponentId = decoder.readSmallLong();
                            int size = decoder.readSmallInt();
                            if (size <= 0) continue block7;
                            ArrayList<ResolvedGraphDependency> deps = new ArrayList<ResolvedGraphDependency>(size);
                            for (int i = 0; i < size; ++i) {
                                deps.add(dependencyResultSerializer.read(decoder, this.failures));
                            }
                            builder.visitOutgoingEdges(fromComponentId, fromVariantId, deps);
                            continue block7;
                        }
                    }
                    break;
                }
                throw new IOException("Unknown value type read from stream: " + type);
            }
            catch (Exception e) {
                throw new RuntimeException("Problems loading the resolution results (" + clock.getElapsed() + "). Read " + valuesRead + " values, last was: " + type, e);
            }
        }
    }
}

