/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.execution.steps;

import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.jspecify.annotations.Nullable;

import java.util.function.Function;

public abstract class BuildOperationStep<C extends Context, R extends Result> implements Step<C, R> {
    private final BuildOperationRunner buildOperationRunner;

    protected BuildOperationStep(BuildOperationRunner buildOperationRunner) {
        this.buildOperationRunner = buildOperationRunner;
    }

    protected <T extends @Nullable Object> T operation(Function<BuildOperationContext, T> operation, BuildOperationDescriptor.Builder description) {
        return buildOperationRunner.call(new CallableBuildOperation<T>() {
            @Override
            public T call(BuildOperationContext context) {
                return operation.apply(context);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return description;
            }
        });
    }
}
