/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.ReproducibleFileVisitor;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.DirectoryBasedTestDefinition;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.detection.TestDetector;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestScanner
implements TestDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTestScanner.class);
    private static final Pattern ANONYMOUS_CLASS_NAME = Pattern.compile(".*\\$\\d+");
    private final FileTree candidateClassFiles;
    private final Set<File> candidateDefinitionDirs;
    private final TestFrameworkDetector testFrameworkDetector;
    private final TestClassProcessor<TestDefinition> testClassProcessor;

    public DefaultTestScanner(FileTree candidateClassFiles, Set<File> candidateDefinitionDirs, TestFrameworkDetector testFrameworkDetector, TestClassProcessor<TestDefinition> testClassProcessor) {
        this.candidateClassFiles = candidateClassFiles;
        this.candidateDefinitionDirs = candidateDefinitionDirs;
        this.testFrameworkDetector = testFrameworkDetector;
        this.testClassProcessor = testClassProcessor;
    }

    public void detect() {
        if (this.testFrameworkDetector == null) {
            this.filenameScan();
        } else {
            this.detectionScan();
        }
    }

    private void detectionScan() {
        this.testFrameworkDetector.startDetection(this.testClassProcessor);
        this.candidateClassFiles.visit((FileVisitor)new ClassFileVisitor(){

            @Override
            public void visitClassFile(FileVisitDetails fileDetails) {
                DefaultTestScanner.this.testFrameworkDetector.processTestClass(new RelativeFile(fileDetails.getFile(), fileDetails.getRelativePath()));
            }
        });
    }

    private void filenameScan() {
        this.candidateClassFiles.visit((FileVisitor)new ClassFileVisitor(){

            @Override
            public void visitClassFile(FileVisitDetails fileDetails) {
                ClassTestDefinition testDefinition = new ClassTestDefinition(DefaultTestScanner.this.getClassName(fileDetails));
                DefaultTestScanner.this.testClassProcessor.processTestDefinition((TestDefinition)testDefinition);
            }
        });
        this.candidateDefinitionDirs.forEach(dir -> {
            boolean isValid = false;
            if (!dir.exists()) {
                LOGGER.warn("Test definitions directory does not exist: " + dir.getAbsolutePath());
            } else if (!dir.isDirectory()) {
                LOGGER.warn("Test definitions directory is not a directory: " + dir.getAbsolutePath());
            } else {
                isValid = true;
            }
            if (isValid) {
                DirectoryBasedTestDefinition testDefinition = new DirectoryBasedTestDefinition(dir);
                this.testClassProcessor.processTestDefinition((TestDefinition)testDefinition);
            }
        });
    }

    private String getClassName(FileVisitDetails fileDetails) {
        return fileDetails.getRelativePath().getPathString().replaceAll("\\.class", "").replace('/', '.');
    }

    private abstract class ClassFileVisitor
    extends EmptyFileVisitor
    implements ReproducibleFileVisitor {
        private ClassFileVisitor() {
        }

        public void visitFile(FileVisitDetails fileDetails) {
            if (this.isClass(fileDetails) && !this.isAnonymousClass(fileDetails)) {
                this.visitClassFile(fileDetails);
            }
        }

        abstract void visitClassFile(FileVisitDetails var1);

        private boolean isAnonymousClass(FileVisitDetails fileVisitDetails) {
            return ANONYMOUS_CLASS_NAME.matcher(DefaultTestScanner.this.getClassName(fileVisitDetails)).matches();
        }

        private boolean isClass(FileVisitDetails fileVisitDetails) {
            String fileName = fileVisitDetails.getFile().getName();
            return fileName.endsWith(".class") && !"module-info.class".equals(fileName);
        }

        public boolean isReproducibleFileOrder() {
            return true;
        }
    }
}

