/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import java.io.IOException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public final class OutputEntry {
    public static final Serializer<OutputEntry> SERIALIZER = new Serializer<OutputEntry>(){
        private static final byte DESTINATION_STDOUT = 1;
        private static final byte DESTINATION_STDERR = 2;

        public OutputEntry read(Decoder decoder) throws IOException {
            long id = decoder.readSmallLong();
            byte destinations = decoder.readByte();
            long startStdout = -1L;
            long startStderr = -1L;
            long end = -1L;
            if ((destinations & 1) != 0) {
                startStdout = decoder.readSmallLong();
            }
            if ((destinations & 2) != 0) {
                startStderr = decoder.readSmallLong();
            }
            if (destinations != 0) {
                end = decoder.readSmallLong();
            }
            return new OutputEntry(id, startStdout, startStderr, end);
        }

        public void write(Encoder encoder, OutputEntry value) throws IOException {
            encoder.writeSmallLong(value.id);
            byte destinations = 0;
            if (value.startStdout != -1L) {
                destinations = (byte)(destinations | 1);
            }
            if (value.startStderr != -1L) {
                destinations = (byte)(destinations | 2);
            }
            encoder.writeByte(destinations);
            if (value.startStdout != -1L) {
                encoder.writeSmallLong(value.startStdout);
            }
            if (value.startStderr != -1L) {
                encoder.writeSmallLong(value.startStderr);
            }
            if (destinations != 0) {
                encoder.writeSmallLong(value.end);
            }
        }
    };
    static final long NO_OUTPUT = -1L;
    final long id;
    final long startStdout;
    final long startStderr;
    final long end;

    private static void validateRange(String name, long start, long end) {
        if (start != -1L) {
            if (start < 0L) {
                throw new IllegalStateException("Invalid " + name + " start: " + start);
            }
            if (end < start) {
                throw new IllegalStateException("Range end " + end + " is before " + name + " start " + start);
            }
        }
    }

    OutputEntry(long id, long startStdout, long startStderr, long end) {
        if (id < 0L) {
            throw new IllegalStateException("Invalid id: " + id);
        }
        OutputEntry.validateRange("stdout", startStdout, end);
        OutputEntry.validateRange("stderr", startStderr, end);
        this.id = id;
        this.startStdout = startStdout;
        this.startStderr = startStderr;
        this.end = end;
    }
}

