/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.project.ProjectTaskLister;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.composite.BuildIncludeListener;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;
import org.gradle.plugins.ide.internal.configurer.DefaultUniqueProjectNameProvider;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;
import org.gradle.plugins.ide.internal.tooling.BasicIdeaModelBuilder;
import org.gradle.plugins.ide.internal.tooling.BuildEnvironmentBuilder;
import org.gradle.plugins.ide.internal.tooling.BuildInvocationsBuilder;
import org.gradle.plugins.ide.internal.tooling.EclipseModelBuilder;
import org.gradle.plugins.ide.internal.tooling.GradleBuildBuilder;
import org.gradle.plugins.ide.internal.tooling.GradleDslBaseScriptModelBuilder;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilder;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IdeaModelBuilder;
import org.gradle.plugins.ide.internal.tooling.IdeaModelBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IsolatedGradleProjectInternalBuilder;
import org.gradle.plugins.ide.internal.tooling.IsolatedIdeaModuleInternalBuilder;
import org.gradle.plugins.ide.internal.tooling.IsolatedProjectsSafeGradleProjectBuilder;
import org.gradle.plugins.ide.internal.tooling.IsolatedProjectsSafeIdeaModelBuilder;
import org.gradle.plugins.ide.internal.tooling.PublicationsBuilder;
import org.gradle.plugins.ide.internal.tooling.ResilientGradleBuildBuilder;
import org.gradle.plugins.ide.internal.tooling.RunBuildDependenciesTaskBuilder;
import org.gradle.plugins.ide.internal.tooling.RunEclipseTasksBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.internal.BuildScopeToolingModelBuilderRegistryAction;
import org.gradle.tooling.provider.model.internal.IntermediateToolingModelProvider;
import org.gradle.tooling.provider.model.internal.PluginApplyingBuilder;

public class ToolingModelServices
extends AbstractGradleModuleServices {
    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new BuildScopeToolingServices());
    }

    private static class BuildScopeToolingServices
    implements ServiceRegistrationProvider {
        private BuildScopeToolingServices() {
        }

        @Provides
        protected UniqueProjectNameProvider createBuildProjectRegistry(ProjectStateRegistry projectRegistry) {
            return new DefaultUniqueProjectNameProvider(projectRegistry);
        }

        @Provides
        protected BuildScopeToolingModelBuilderRegistryAction createIdeBuildScopeToolingModelBuilderRegistryAction(final ProjectTaskLister taskLister, final ProjectPublicationRegistry projectPublicationRegistry, final FileCollectionFactory fileCollectionFactory, final BuildStateRegistry buildStateRegistry, final ProjectStateRegistry projectStateRegistry, final BuildModelParameters buildModelParameters, final IntermediateToolingModelProvider intermediateToolingModelProvider, final BuildIncludeListener failedIncludedBuildsRegistry) {
            return new BuildScopeToolingModelBuilderRegistryAction(){

                public void execute(ToolingModelBuilderRegistry registry) {
                    boolean isolatedProjects = buildModelParameters.isIsolatedProjects();
                    GradleProjectBuilderInternal gradleProjectBuilder = this.createGradleProjectBuilder(isolatedProjects);
                    IdeaModelBuilderInternal ideaModelBuilder = this.createIdeaModelBuilder(isolatedProjects, gradleProjectBuilder);
                    registry.register((ToolingModelBuilder)new RunBuildDependenciesTaskBuilder());
                    registry.register((ToolingModelBuilder)new RunEclipseTasksBuilder());
                    registry.register((ToolingModelBuilder)new EclipseModelBuilder(gradleProjectBuilder, projectStateRegistry));
                    registry.register((ToolingModelBuilder)ideaModelBuilder);
                    registry.register((ToolingModelBuilder)gradleProjectBuilder);
                    registry.register(this.createGradleBuildBuilder());
                    registry.register((ToolingModelBuilder)new BasicIdeaModelBuilder(ideaModelBuilder));
                    registry.register((ToolingModelBuilder)new BuildInvocationsBuilder(taskLister));
                    registry.register((ToolingModelBuilder)new PublicationsBuilder(projectPublicationRegistry));
                    registry.register((ToolingModelBuilder)new BuildEnvironmentBuilder(fileCollectionFactory));
                    registry.register((ToolingModelBuilder)new IsolatedGradleProjectInternalBuilder());
                    registry.register((ToolingModelBuilder)new IsolatedIdeaModuleInternalBuilder());
                    registry.register((ToolingModelBuilder)new PluginApplyingBuilder());
                    registry.register((ToolingModelBuilder)new GradleDslBaseScriptModelBuilder());
                }

                private ToolingModelBuilder createGradleBuildBuilder() {
                    return buildModelParameters.isResilientModelBuilding() ? new ResilientGradleBuildBuilder(buildStateRegistry, failedIncludedBuildsRegistry) : new GradleBuildBuilder(buildStateRegistry);
                }

                private IdeaModelBuilderInternal createIdeaModelBuilder(boolean isolatedProjects, GradleProjectBuilderInternal gradleProjectBuilder) {
                    return isolatedProjects ? new IsolatedProjectsSafeIdeaModelBuilder(intermediateToolingModelProvider, gradleProjectBuilder) : new IdeaModelBuilder(gradleProjectBuilder);
                }

                private GradleProjectBuilderInternal createGradleProjectBuilder(boolean isolatedProjects) {
                    return isolatedProjects ? new IsolatedProjectsSafeGradleProjectBuilder(intermediateToolingModelProvider) : new GradleProjectBuilder();
                }
            };
        }
    }
}

