/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.platform.base.Variant;
import org.gradle.platform.base.internal.VariantAspect;
import org.jspecify.annotations.Nullable;

public class VariantAspectExtractionStrategy
implements ModelSchemaAspectExtractionStrategy {
    public @Nullable ModelSchemaAspectExtractionResult extract(ModelSchemaExtractionContext<?> extractionContext, List<ModelPropertyExtractionResult<?>> propertyResults) {
        ImmutableSet.Builder dimensionsBuilder = ImmutableSet.builder();
        for (ModelPropertyExtractionResult<?> propertyResult : propertyResults) {
            ModelProperty property = propertyResult.getProperty();
            for (PropertyAccessorExtractionContext accessor : propertyResult.getAccessors()) {
                if (!accessor.isAnnotationPresent(Variant.class)) continue;
                if (accessor.getAccessorType() == PropertyAccessorType.SETTER) {
                    throw this.invalidProperty(extractionContext, property, "@Variant annotation is only allowed on getter methods");
                }
                Class propertyType = property.getType().getRawClass();
                if (!String.class.equals((Object)propertyType) && !Named.class.isAssignableFrom(propertyType)) {
                    throw this.invalidProperty(extractionContext, property, String.format("@Variant annotation only allowed for properties of type String and %s, but property has type %s", Named.class.getName(), propertyType.getName()));
                }
                dimensionsBuilder.add((Object)property);
            }
        }
        ImmutableSet dimensions = dimensionsBuilder.build();
        if (dimensions.isEmpty()) {
            return null;
        }
        return new ModelSchemaAspectExtractionResult((ModelSchemaAspect)new VariantAspect((Set<ModelProperty<?>>)dimensions));
    }

    protected InvalidManagedModelElementTypeException invalidProperty(ModelSchemaExtractionContext<?> extractionContext, ModelProperty<?> property, String message) {
        return new InvalidManagedModelElementTypeException(extractionContext, String.format("%s (invalid property: %s)", message, property.getName()));
    }
}

