/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.file.PathUtils;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.GenericPageRenderer;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputReader;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.SafeFileLocationUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.reporting.HtmlReportBuilder;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;

public abstract class GenericHtmlTestReportGenerator
implements TestReportGenerator {
    private static final Logger LOG = Logging.getLogger(GenericHtmlTestReportGenerator.class);
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationExecutor buildOperationExecutor;
    private final MetadataRendererRegistry metadataRendererRegistry;
    private final Path reportsDirectory;

    public static String getFilePath(org.gradle.util.Path path) {
        String filePath = path.segmentCount() == 0 ? "index.html" : String.join((CharSequence)"/", Iterables.transform((Iterable)path.segments(), SafeFileLocationUtils::toSafeFileName)) + "/index.html";
        return filePath;
    }

    @Inject
    public GenericHtmlTestReportGenerator(BuildOperationRunner buildOperationRunner, BuildOperationExecutor buildOperationExecutor, MetadataRendererRegistry metadataRendererRegistry, Path reportsDirectory) {
        this.buildOperationRunner = buildOperationRunner;
        this.buildOperationExecutor = buildOperationExecutor;
        this.metadataRendererRegistry = metadataRendererRegistry;
        this.reportsDirectory = reportsDirectory;
    }

    @Override
    public Path generate(List<Path> resultsDirectories) {
        List<SerializableTestResultStore> stores = resultsDirectories.stream().distinct().map(SerializableTestResultStore::new).filter(SerializableTestResultStore::hasResults).collect(Collectors.toList());
        try {
            Files.createDirectories(this.reportsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        Serializer testOutputEventSerializer = TestEventSerializer.create().build(TestOutputEvent.class);
        ArrayList<TestOutputReader> outputReaders = new ArrayList<TestOutputReader>(stores.size());
        try {
            for (SerializableTestResultStore store : stores) {
                outputReaders.add(store.createOutputReader((Serializer<TestOutputEvent>)testOutputEventSerializer));
            }
            TestTreeModel root = TestTreeModel.loadModelFromStores(stores);
            this.generateReport(root, outputReaders);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            CompositeStoppable.stoppable(outputReaders).stop();
        }
        return this.reportsDirectory.resolve("index.html");
    }

    private void generateReport(TestTreeModel root, List<TestOutputReader> outputReaders) {
        LOG.info("Generating HTML test report...");
        Timer clock = Time.startTimer();
        this.generateFiles(root, outputReaders);
        LOG.info("Finished generating test html results ({}) into: {}", (Object)clock.getElapsed(), (Object)this.reportsDirectory);
    }

    private void generateFiles(TestTreeModel model, final List<TestOutputReader> outputReaders) {
        try {
            HtmlReportRenderer htmlRenderer = new HtmlReportRenderer();
            this.buildOperationRunner.run((RunnableBuildOperation)new DeleteOldReportOperation(this.reportsDirectory));
            ArrayListMultimap namesToIndexes = ArrayListMultimap.create();
            final ArrayList<String> rootDisplayNames = new ArrayList<String>(model.getPerRootInfo().size());
            for (int i = 0; i < model.getPerRootInfo().size(); ++i) {
                List perRootInfos = model.getPerRootInfo().get((Object)i);
                if (perRootInfos.isEmpty()) {
                    throw new IllegalStateException("Root model is missing display name info for root index " + i);
                }
                if (perRootInfos.size() > 1) {
                    throw new IllegalStateException("Root model has multiple display name infos for root index " + i + ": " + Iterables.toString((Iterable)perRootInfos));
                }
                String displayName = ((TestTreeModel.PerRootInfo)perRootInfos.get(0)).getResult().getDisplayName();
                rootDisplayNames.add(displayName);
                namesToIndexes.put((Object)displayName, (Object)i);
            }
            Multimaps.asMap((ListMultimap)namesToIndexes).forEach((name, indexes) -> {
                if (indexes.size() > 1) {
                    for (int nameRepeatIndex = 0; nameRepeatIndex < indexes.size(); ++nameRepeatIndex) {
                        int rootIndex = (Integer)indexes.get(nameRepeatIndex);
                        rootDisplayNames.set(rootIndex, name + " (" + (nameRepeatIndex + 1) + ")");
                    }
                }
            });
            htmlRenderer.render((Object)model, (ReportRenderer)new ReportRenderer<TestTreeModel, HtmlReportBuilder>(){

                public void render(TestTreeModel model, HtmlReportBuilder output) {
                    GenericHtmlTestReportGenerator.this.buildOperationExecutor.runAll(queue -> this.queueTree((BuildOperationQueue<RunnableBuildOperation>)queue, model, output));
                }

                private void queueTree(BuildOperationQueue<RunnableBuildOperation> queue, TestTreeModel tree, HtmlReportBuilder output) {
                    String filePath = GenericHtmlTestReportGenerator.getFilePath(tree.getPath());
                    queue.add((BuildOperation)new HtmlReportFileGenerator(filePath, tree, output, outputReaders, rootDisplayNames, GenericHtmlTestReportGenerator.this.metadataRendererRegistry));
                    for (String child : tree.getChildren().keySet()) {
                        this.queueTree(queue, tree.getChildren().get(child), output);
                    }
                }
            }, this.reportsDirectory.toFile());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not generate test report to '%s'.", this.reportsDirectory), (Throwable)e);
        }
    }

    private static final class DeleteOldReportOperation
    implements RunnableBuildOperation {
        private final Path reportsDirectory;

        private DeleteOldReportOperation(Path reportsDirectory) {
            this.reportsDirectory = reportsDirectory;
        }

        public void run(BuildOperationContext context) {
            Path indexHtml = this.reportsDirectory.resolve("index.html");
            try {
                PathUtils.deleteFile((Path)indexHtml);
            }
            catch (IOException e) {
                LOG.info("Could not delete HTML test reports index.html '{}'.", (Object)indexHtml, (Object)e);
            }
            try (Stream<Path> children = Files.list(this.reportsDirectory);){
                for (Path dir : children.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList())) {
                    PathUtils.deleteDirectory((Path)dir);
                }
            }
            catch (IOException e) {
                LOG.info("Could not clean HTML test reports directory '{}'.", (Object)this.reportsDirectory, (Object)e);
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Delete old generic HTML results");
        }
    }

    private static final class HtmlReportFileGenerator
    implements RunnableBuildOperation {
        private final String fileUrl;
        private final TestTreeModel results;
        private final HtmlReportBuilder output;
        private final List<TestOutputReader> outputReaders;
        private final List<String> rootDisplayNames;
        private final MetadataRendererRegistry metadataRendererRegistry;

        HtmlReportFileGenerator(String fileUrl, TestTreeModel results, HtmlReportBuilder output, List<TestOutputReader> outputReaders, List<String> rootDisplayNames, MetadataRendererRegistry metadataRendererRegistry) {
            this.fileUrl = fileUrl;
            this.results = results;
            this.output = output;
            this.outputReaders = outputReaders;
            this.rootDisplayNames = rootDisplayNames;
            this.metadataRendererRegistry = metadataRendererRegistry;
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Generate generic HTML test report for " + this.results.getPath().getName()));
        }

        public void run(BuildOperationContext context) {
            this.output.renderHtmlPage(this.fileUrl, (Object)this.results, (ReportRenderer)new GenericPageRenderer(this.outputReaders, this.rootDisplayNames, this.metadataRendererRegistry));
        }
    }
}

