/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.dsl.ImmutableModuleReplacements;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionParameters;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.LatestModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ProjectDependencyForcingResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Project.class})
public class DependencyGraphResolver {
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;
    private final InstantiatorFactory instantiatorFactory;
    private final ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final InMemoryCacheFactory cacheFactory;

    @Inject
    public DependencyGraphResolver(VersionComparator versionComparator, VersionParser versionParser, InstantiatorFactory instantiatorFactory, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, DependencyGraphBuilder dependencyGraphBuilder, InMemoryCacheFactory cacheFactory) {
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.instantiatorFactory = instantiatorFactory;
        this.componentSelectionDescriptorFactory = componentSelectionDescriptorFactory;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.cacheFactory = cacheFactory;
    }

    public void resolve(LocalComponentGraphResolveState rootComponent, LocalVariantGraphResolveState rootVariant, List<? extends DependencyMetadata> syntheticDependencies, Spec<? super DependencyMetadata> edgeFilter, ComponentSelectorConverter componentSelectorConverter, DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ImmutableModuleReplacements moduleReplacements, ImmutableActionSet<DependencySubstitutionInternal> dependencySubstitutionRule, ConflictResolution conflictResolution, ImmutableList<CapabilitiesResolutionInternal.CapabilityResolutionRule> capabilityResolutionRules, boolean failingOnDynamicVersions, boolean failingOnChangingVersions, ResolutionParameters.FailureResolutions failureResolutions, DependencyGraphVisitor modelVisitor) {
        DependencySubstitutionApplicator substitutionApplicator = this.createDependencySubstitutionApplicator(dependencySubstitutionRule);
        ModuleConflictResolver<ComponentState> moduleConflictResolver = this.createModuleConflictResolver(conflictResolution);
        this.dependencyGraphBuilder.resolve(rootComponent, rootVariant, syntheticDependencies, edgeFilter, componentSelectorConverter, componentIdResolver, componentMetaDataResolver, moduleReplacements, substitutionApplicator, moduleConflictResolver, capabilityResolutionRules, conflictResolution, failingOnDynamicVersions, failingOnChangingVersions, failureResolutions, modelVisitor);
    }

    private DependencySubstitutionApplicator createDependencySubstitutionApplicator(ImmutableActionSet<DependencySubstitutionInternal> dependencySubstitutionRule) {
        if (dependencySubstitutionRule.isEmpty()) {
            return DependencySubstitutionApplicator.NO_OP;
        }
        return new DefaultDependencySubstitutionApplicator(this.componentSelectionDescriptorFactory, (Action<? super DependencySubstitutionInternal>)dependencySubstitutionRule, this.instantiatorFactory, this.cacheFactory);
    }

    private ModuleConflictResolver<ComponentState> createModuleConflictResolver(ConflictResolution conflictResolution) {
        LatestModuleConflictResolver<ComponentState> moduleConflictResolver = new LatestModuleConflictResolver<ComponentState>(this.versionComparator, this.versionParser);
        if (conflictResolution != ConflictResolution.preferProjectModules) {
            return moduleConflictResolver;
        }
        return new ProjectDependencyForcingResolver<ComponentState>(moduleConflictResolver);
    }
}

