/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLICompilerKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.pipeline.ArgumentsPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PipelineArtifactWithExitCode;
import org.jetbrains.kotlin.cli.pipeline.PipelineContext;
import org.jetbrains.kotlin.cli.pipeline.PipelineStepException;
import org.jetbrains.kotlin.cli.pipeline.SuccessfulPipelineExecutionException;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.LoggingContext;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.config.phaser.CompilerPhase;
import org.jetbrains.kotlin.config.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.util.CompilerType;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.util.UnitStatsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J+\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0019\u001a\u00020\u00162\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001dR\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/AbstractCliPipeline;", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "", "<init>", "()V", "execute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "originalMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "runPhasedPipeline", "input", "Lorg/jetbrains/kotlin/cli/pipeline/ArgumentsPipelineArtifact;", "createCompoundPhase", "Lorg/jetbrains/kotlin/config/phaser/CompilerPhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelineContext;", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Lorg/jetbrains/kotlin/config/phaser/CompilerPhase;", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/util/PerformanceManager;", "createPerformanceManager", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/config/Services;)Lorg/jetbrains/kotlin/util/PerformanceManager;", "isKaptMode", "", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Z", "cli"})
@SourceDebugExtension(value={"SMAP\nAbstractCliPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCliPipeline.kt\norg/jetbrains/kotlin/cli/pipeline/AbstractCliPipeline\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public abstract class AbstractCliPipeline<A extends CommonCompilerArguments> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExitCode execute(@NotNull A arguments, @NotNull Services services, @NotNull MessageCollector originalMessageCollector) {
        ExitCode exitCode;
        PerformanceManager performanceManager;
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)originalMessageCollector, (String)"originalMessageCollector");
        CompilationCanceledStatus canceledStatus = services.get(CompilationCanceledStatus.class);
        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(canceledStatus);
        Disposable disposable = Disposer.newDisposable("Disposable for " + Reflection.getOrCreateKotlinClass(CLICompiler.class).getSimpleName() + ".execImpl");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable rootDisposable = disposable;
        UtilKt.setIdeaIoUseFallback();
        PerformanceManager $this$execute_u24lambda_u240 = performanceManager = this.createPerformanceManager(arguments, services);
        boolean bl = false;
        $this$execute_u24lambda_u240.setCompilerType(CompilerType.K2);
        PerformanceManager performanceManager2 = performanceManager;
        if (((CommonCompilerArguments)arguments).getReportPerf() || ((CommonCompilerArguments)arguments).getDumpPerf() != null) {
            performanceManager2.enableExtendedStats();
        }
        GroupingMessageCollector messageCollector = new GroupingMessageCollector(originalMessageCollector, ((CommonToolArguments)arguments).getAllWarningsAsErrors(), ((CommonCompilerArguments)arguments).getReportAllWarnings());
        ArgumentsPipelineArtifact<A> argumentsInput = new ArgumentsPipelineArtifact<A>(arguments, services, rootDisposable, messageCollector, performanceManager2);
        try {
            ExitCode code = this.runPhasedPipeline(argumentsInput);
            performanceManager2.notifyCompilationFinished();
            if (((CommonCompilerArguments)arguments).getReportPerf()) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "PERF: " + performanceManager2.getTargetInfo(), null, 4, null);
                UnitStatsKt.forEachStringMeasurement(performanceManager2.getUnitStats(), (Function1<? super String, Unit>)((Function1)arg_0 -> AbstractCliPipeline.execute$lambda$1(messageCollector, arg_0)));
            }
            if (((CommonCompilerArguments)arguments).getDumpPerf() != null) {
                String string = ((CommonCompilerArguments)arguments).getDumpPerf();
                Intrinsics.checkNotNull((Object)string);
                performanceManager2.dumpPerformanceReport(string);
            }
            exitCode = messageCollector.hasErrors() ? ExitCode.COMPILATION_ERROR : code;
        }
        catch (CompilationErrorException compilationErrorException) {
            exitCode = ExitCode.COMPILATION_ERROR;
        }
        catch (RuntimeException e2) {
            Throwable cause = e2.getCause();
            exitCode = cause instanceof CompilationCanceledException ? AbstractCliPipeline.execute$reportCompilationCanceled(messageCollector, (CompilationCanceledException)cause) : AbstractCliPipeline.execute$reportException(messageCollector, e2);
        }
        catch (Throwable t2) {
            exitCode = AbstractCliPipeline.execute$reportException(messageCollector, t2);
        }
        finally {
            messageCollector.flush();
            UtilsKt.disposeRootInWriteAction(rootDisposable);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExitCode runPhasedPipeline(ArgumentsPipelineArtifact<? extends A> input) {
        ExitCode exitCode;
        CompilerPhase<PipelineContext, ArgumentsPipelineArtifact<A>, ?> compoundPhase = this.createCompoundPhase(input.getArguments());
        PhaseConfig phaseConfig = new PhaseConfig(null, null, null, null, null, null, null, null, false, false, 1023, null);
        PipelineContext context2 = new PipelineContext(input.getMessageCollector(), input.getDiagnosticCollector(), input.getPerformanceManager(), ((CommonCompilerArguments)input.getArguments()).getRenderInternalDiagnosticNames(), this.isKaptMode(input.getArguments()));
        try {
            Object result2 = CompilerPhaseKt.invokeToplevel(compoundPhase, phaseConfig, (LoggingContext)context2, input);
            exitCode = result2 instanceof PipelineArtifactWithExitCode ? ((PipelineArtifactWithExitCode)result2).getExitCode() : ExitCode.OK;
        }
        catch (PipelineStepException e2) {
            exitCode = e2.getDefinitelyCompilationError() || input.getMessageCollector().hasErrors() || input.getDiagnosticCollector().getHasErrors() ? ExitCode.COMPILATION_ERROR : ExitCode.OK;
        }
        catch (SuccessfulPipelineExecutionException successfulPipelineExecutionException) {
            exitCode = ExitCode.OK;
        }
        finally {
            CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE.reportDiagnosticsToMessageCollector(context2);
        }
        return exitCode;
    }

    @NotNull
    public abstract CompilerPhase<PipelineContext, ArgumentsPipelineArtifact<A>, ?> createCompoundPhase(@NotNull A var1);

    @NotNull
    public abstract PerformanceManager getDefaultPerformanceManager();

    @NotNull
    protected PerformanceManager createPerformanceManager(@NotNull A arguments, @NotNull Services services) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        return this.getDefaultPerformanceManager();
    }

    protected boolean isKaptMode(@NotNull A arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return false;
    }

    private static final ExitCode execute$reportException(GroupingMessageCollector messageCollector, Throwable e2) {
        MessageCollectorUtil.reportException(messageCollector, e2);
        return e2 instanceof OutOfMemoryError || CLICompilerKt.hasOOMCause(e2) ? ExitCode.OOM_ERROR : ExitCode.INTERNAL_ERROR;
    }

    private static final ExitCode execute$reportCompilationCanceled(GroupingMessageCollector messageCollector, CompilationCanceledException e2) {
        CLICompilerKt.reportCompilationCancelled(messageCollector, e2);
        return ExitCode.OK;
    }

    private static final Unit execute$lambda$1(GroupingMessageCollector $messageCollector, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $messageCollector.report(CompilerMessageSeverity.LOGGING, "PERF: " + it, null);
        return Unit.INSTANCE;
    }
}

