/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputReader;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.IoConsumer;
import org.jspecify.annotations.Nullable;

public final class TestTreeModelResultsProvider
implements TestResultsProvider {
    private static final Comparator<TestTreeModel.PerRootInfo> PER_ROOT_INFO_BY_START_TIME = Comparator.comparing(leaf -> leaf.getResult().getStartTime());
    private final Map<Long, ClassNode> classesById;
    private final TestOutputReader outputReader;

    public static void useResultsFrom(Path resultsDir, Consumer<TestTreeModelResultsProvider> resultsConsumer) {
        SerializableTestResultStore resultsStore = new SerializableTestResultStore(resultsDir);
        try {
            TestTreeModel root = TestTreeModel.loadModelFromStores(Collections.singletonList(resultsStore));
            TestTreeModelResultsProvider resultsProvider = new TestTreeModelResultsProvider(root, resultsStore.createOutputReader());
            resultsConsumer.accept(resultsProvider);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static Map<Long, ClassNode> createClasses(TestTreeModel root) {
        LinkedListMultimap leavesByGroupingNode = LinkedListMultimap.create();
        TestTreeModelResultsProvider.walkLeaves(root, arg_0 -> TestTreeModelResultsProvider.lambda$createClasses$1((ListMultimap)leavesByGroupingNode, arg_0));
        ImmutableMap.Builder classesById = ImmutableMap.builderWithExpectedSize((int)leavesByGroupingNode.keySet().size());
        long nextClassId = 1L;
        for (Map.Entry entry : Multimaps.asMap((ListMultimap)leavesByGroupingNode).entrySet()) {
            TestTreeModel groupingNode = (TestTreeModel)entry.getKey();
            ArrayList<TestTreeModel.PerRootInfo> leaves = new ArrayList<TestTreeModel.PerRootInfo>((Collection)entry.getValue());
            leaves.sort(PER_ROOT_INFO_BY_START_TIME);
            ImmutableMap.Builder methodOutputEntries = ImmutableMap.builder();
            TestClassResult classResult = TestTreeModelResultsProvider.buildClassResult(groupingNode, leaves, nextClassId, (ImmutableMap.Builder<Long, OutputEntry>)methodOutputEntries);
            ++nextClassId;
            ImmutableList.Builder outputEntries = ImmutableList.builder();
            groupingNode.walkDepthFirst(node -> {
                if (node.getChildren().isEmpty()) {
                    return;
                }
                for (TestTreeModel.PerRootInfo perRootInfo : node.getPerRootInfo().get((Object)0)) {
                    outputEntries.add((Object)perRootInfo.getOutputEntry());
                }
            });
            classesById.put((Object)classResult.getId(), (Object)new ClassNode(classResult, (ImmutableList<OutputEntry>)outputEntries.build(), (ImmutableMap<Long, OutputEntry>)methodOutputEntries.build()));
        }
        return classesById.build();
    }

    private static TestClassResult buildClassResult(TestTreeModel groupingNode, List<TestTreeModel.PerRootInfo> leaves, long nextClassId, ImmutableMap.Builder<Long, OutputEntry> methodOutputEntries) {
        TestClassResult classResult = TestTreeModelResultsProvider.createEmptyClassResult(groupingNode, nextClassId);
        for (TestTreeModel.PerRootInfo leafPerRootInfo : leaves) {
            classResult.add(TestTreeModelResultsProvider.buildMethodResult(leafPerRootInfo));
            methodOutputEntries.put((Object)leafPerRootInfo.getId(), (Object)leafPerRootInfo.getOutputEntry());
        }
        return classResult;
    }

    private static TestClassResult createEmptyClassResult(TestTreeModel groupingNode, long nextClassId) {
        List perRootInfos = groupingNode.getPerRootInfo().get((Object)0);
        if (perRootInfos.size() != 1) {
            throw new IllegalStateException("Expected exactly one run for grouping node " + groupingNode.getPath() + " but found: " + perRootInfos.size());
        }
        TestTreeModel.PerRootInfo perRootInfo = (TestTreeModel.PerRootInfo)perRootInfos.get(0);
        return new TestClassResult(nextClassId, perRootInfo.getResult().getName(), perRootInfo.getResult().getDisplayName(), perRootInfo.getResult().getStartTime());
    }

    private static TestMethodResult buildMethodResult(TestTreeModel.PerRootInfo perRootInfo) {
        SerializableTestResult result = perRootInfo.getResult();
        TestMethodResult methodResult = new TestMethodResult(perRootInfo.getId(), result.getName(), result.getDisplayName(), result.getResultType(), result.getDuration(), result.getEndTime());
        methodResult.getFailures().addAll((Collection<SerializableFailure>)result.getFailures());
        if (result.getAssumptionFailure() != null) {
            SerializableFailure assumptionFailure = result.getAssumptionFailure();
            methodResult.setAssumptionFailure(assumptionFailure.getMessage(), assumptionFailure.getStackTrace(), assumptionFailure.getExceptionType());
        }
        return methodResult;
    }

    private static TestTreeModel findGroupingNode(TestTreeModel leaf, @Nullable String className) {
        TestTreeModel parent;
        TestTreeModel current = leaf;
        while ((parent = current.getParent()) != null) {
            if (className != null && className.equals(parent.getPath().getName())) {
                return parent;
            }
            if (parent.getParent() == null && current != leaf) {
                return current;
            }
            current = parent;
        }
        return current;
    }

    private static void walkLeaves(TestTreeModel base, Consumer<TestTreeModel> leafConsumer) {
        base.walkDepthFirst(node -> {
            if (node.getChildren().isEmpty() && node.getParent() != null) {
                leafConsumer.accept((TestTreeModel)node);
            }
        });
    }

    public TestTreeModelResultsProvider(TestTreeModel root, TestOutputReader outputReader) {
        this.classesById = TestTreeModelResultsProvider.createClasses(root);
        this.outputReader = outputReader;
    }

    @Override
    public void visitClasses(Action<? super TestClassResult> visitor) {
        for (ClassNode value : this.classesById.values()) {
            visitor.execute((Object)value.result);
        }
    }

    @Override
    public void writeAllOutput(long classId, TestOutputEvent.Destination destination, Writer writer) {
        ClassNode classNode = this.classesById.get(classId);
        if (classNode == null) {
            throw new IllegalArgumentException("No class with id " + classId);
        }
        try {
            this.outputReader.useTestOutputEvents(Iterables.concat(classNode.outputEntries, (Iterable)classNode.methodOutputEntries.values()), destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> writer.write(event.getMessage())));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void writeNonTestOutput(long classId, TestOutputEvent.Destination destination, Writer writer) {
        ClassNode classNode = this.classesById.get(classId);
        if (classNode == null) {
            throw new IllegalArgumentException("No class with id " + classId);
        }
        try {
            this.outputReader.useTestOutputEvents((Iterable<OutputEntry>)classNode.outputEntries, destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> writer.write(event.getMessage())));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void writeTestOutput(long classId, long testId, TestOutputEvent.Destination destination, Writer writer) {
        ClassNode classNode = this.classesById.get(classId);
        if (classNode == null) {
            throw new IllegalArgumentException("No class with id " + classId);
        }
        OutputEntry testEntry = (OutputEntry)classNode.methodOutputEntries.get((Object)testId);
        if (testEntry == null) {
            throw new IllegalArgumentException("No test with id " + testId + " in class with id " + classId);
        }
        try {
            this.outputReader.useTestOutputEvents(testEntry, destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> writer.write(event.getMessage())));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public boolean hasOutput(long classId, long testId, TestOutputEvent.Destination destination) {
        OutputEntry entry;
        ClassNode model = this.classesById.get(classId);
        if (model != null && (entry = (OutputEntry)model.methodOutputEntries.get((Object)testId)) != null) {
            return this.outputReader.hasOutput(entry, destination);
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.outputReader.close();
    }

    private static /* synthetic */ void lambda$createClasses$1(ListMultimap leavesByGroupingNode, TestTreeModel leaf) {
        for (TestTreeModel.PerRootInfo perRootInfo : leaf.getPerRootInfo().get((Object)0)) {
            TestTreeModel groupingNode = TestTreeModelResultsProvider.findGroupingNode(leaf, perRootInfo.getResult().getClassName());
            leavesByGroupingNode.put((Object)groupingNode, (Object)perRootInfo);
        }
    }

    private static final class ClassNode {
        final TestClassResult result;
        final ImmutableList<OutputEntry> outputEntries;
        final ImmutableMap<Long, OutputEntry> methodOutputEntries;

        ClassNode(TestClassResult result, ImmutableList<OutputEntry> outputEntries, ImmutableMap<Long, OutputEntry> methodOutputEntries) {
            this.result = result;
            this.outputEntries = outputEntries;
            this.methodOutputEntries = methodOutputEntries;
        }
    }
}

