/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class TestTreeModel {
    private static final TestTreeModel EMPTY_MODEL = new TestTreeModel(null, Path.ROOT, (ListMultimap<Integer, PerRootInfo>)ImmutableListMultimap.of(), (Map<String, TestTreeModel>)ImmutableMap.of());
    private final @Nullable TestTreeModel parent;
    private final Path path;
    private final ListMultimap<Integer, PerRootInfo> perRootInfo;
    private final Map<String, TestTreeModel> children;
    private static final int INDENT_SIZE = 2;

    public static TestTreeModel loadModelFromStores(List<SerializableTestResultStore> stores) throws IOException {
        HashMap<Path, TestTreeModel> modelsByPath = new HashMap<Path, TestTreeModel>();
        for (int i = 0; i < stores.size(); ++i) {
            SerializableTestResultStore store = stores.get(i);
            store.forEachResult(new StoreLoader(i, modelsByPath));
        }
        return modelsByPath.getOrDefault(Path.ROOT, EMPTY_MODEL);
    }

    private TestTreeModel(@Nullable TestTreeModel parent, Path path, ListMultimap<Integer, PerRootInfo> perRootInfo, Map<String, TestTreeModel> children) {
        this.parent = parent;
        this.path = path;
        this.perRootInfo = perRootInfo;
        this.children = children;
    }

    public @Nullable TestTreeModel getParent() {
        return this.parent;
    }

    public Path getPath() {
        return this.path;
    }

    public ListMultimap<Integer, PerRootInfo> getPerRootInfo() {
        return Multimaps.unmodifiableListMultimap(this.perRootInfo);
    }

    public Map<String, TestTreeModel> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public Iterable<TestTreeModel> getChildrenOf(int rootIndex) {
        PerRootInfo perRootInfoWithChildren = this.perRootInfo.get((Object)rootIndex).stream().filter(info -> !((PerRootInfo)info).children.isEmpty()).findFirst().orElse(null);
        if (perRootInfoWithChildren == null) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)ImmutableSet.copyOf(perRootInfoWithChildren.getChildren()), this.children::get);
    }

    public int getDepth() {
        int deepest = 0;
        for (TestTreeModel treeModel : this.children.values()) {
            int depth = treeModel.getDepth();
            if (depth <= deepest) continue;
            deepest = depth;
        }
        return deepest + 1;
    }

    public void walkDepthFirst(Consumer<TestTreeModel> consumer) {
        consumer.accept(this);
        for (TestTreeModel child : this.children.values()) {
            child.walkDepthFirst(consumer);
        }
    }

    public void dumpStructure(Appendable appendable) {
        this.dumpStructure(appendable, 0);
    }

    private void dumpStructure(Appendable appendable, int indent) {
        try {
            for (int i = 0; i < indent; ++i) {
                appendable.append(' ');
            }
            String name = this.path.segmentCount() == 0 ? ":" : this.path.getName();
            appendable.append("- ").append(name).append('\n');
            for (TestTreeModel child : this.children.values()) {
                child.dumpStructure(appendable, indent + 2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to dump test tree structure", e);
        }
    }

    private static final class StoreLoader
    implements Consumer<SerializableTestResultStore.OutputTrackedResult> {
        private final int rootIndex;
        private final Map<Path, TestTreeModel> modelsByPath;
        private final ListMultimap<Long, Child> childrenByParentId;

        public StoreLoader(int rootIndex, Map<Path, TestTreeModel> modelsByPath) {
            this.rootIndex = rootIndex;
            this.modelsByPath = modelsByPath;
            this.childrenByParentId = ArrayListMultimap.create();
        }

        @Override
        public void accept(SerializableTestResultStore.OutputTrackedResult result) {
            List children = this.childrenByParentId.get((Object)result.getOutputId());
            int totalLeafCount = 0;
            int failedLeafCount = 0;
            int skippedLeafCount = 0;
            for (Child child : children) {
                totalLeafCount += child.info.totalLeafCount;
                failedLeafCount += child.info.failedLeafCount;
                skippedLeafCount += child.info.skippedLeafCount;
            }
            if (children.isEmpty()) {
                totalLeafCount = 1;
                if (result.getInnerResult().getResultType() == TestResult.ResultType.FAILURE) {
                    failedLeafCount = 1;
                } else if (result.getInnerResult().getResultType() == TestResult.ResultType.SKIPPED) {
                    skippedLeafCount = 1;
                }
            }
            ArrayList<String> childNames = new ArrayList<String>(children.size());
            BitSet childIsLeaf = new BitSet(children.size());
            for (int i = 0; i < children.size(); ++i) {
                Child child = (Child)children.get(i);
                String name = child.info.getResult().getName();
                childNames.add(name);
                if (!child.info.children.isEmpty()) continue;
                childIsLeaf.set(i);
            }
            PerRootInfo thisInfo = new PerRootInfo(result, childNames, childIsLeaf, totalLeafCount, failedLeafCount, skippedLeafCount);
            OptionalLong parentOutputId = result.getParentOutputId();
            if (!parentOutputId.isPresent()) {
                this.finalizePath(null, Path.ROOT, result.getOutputId(), thisInfo);
            } else {
                this.childrenByParentId.put((Object)parentOutputId.getAsLong(), (Object)new Child(result.getOutputId(), thisInfo));
            }
        }

        private void finalizePath(@Nullable TestTreeModel parent, Path path, long id, PerRootInfo rootInfo) {
            TestTreeModel model = this.modelsByPath.computeIfAbsent(path, p -> new TestTreeModel(parent, (Path)p, (ListMultimap)LinkedListMultimap.create(), new LinkedHashMap()));
            List existingRootInfos = model.perRootInfo.get((Object)this.rootIndex);
            if (!existingRootInfos.isEmpty()) {
                boolean isLeaf = rootInfo.children.isEmpty();
                if (isLeaf) {
                    existingRootInfos.add(rootInfo);
                } else {
                    PerRootInfo toMerge = existingRootInfos.stream().filter(info -> !((PerRootInfo)info).children.isEmpty()).findFirst().orElseGet(() -> (PerRootInfo)existingRootInfos.get(0));
                    toMerge.merge(rootInfo);
                }
            } else {
                existingRootInfos.add(rootInfo);
            }
            List children = this.childrenByParentId.get((Object)id);
            for (Child child : children) {
                String name = child.info.getResult().getName();
                Path childPath = path.child(name);
                this.finalizePath(model, childPath, child.id, child.info);
                model.children.computeIfAbsent(name, n -> this.modelsByPath.get(childPath));
            }
        }

        private static final class Child {
            private final long id;
            private final PerRootInfo info;

            private Child(long id, PerRootInfo info) {
                this.id = id;
                this.info = info;
            }
        }
    }

    public static final class PerRootInfo {
        private SerializableTestResultStore.OutputTrackedResult outputTrackedResult;
        private final List<String> children;
        private final BitSet childIsLeaf;
        private int totalLeafCount;
        private int failedLeafCount;
        private int skippedLeafCount;

        public PerRootInfo(SerializableTestResultStore.OutputTrackedResult outputTrackedResult, List<String> children, BitSet childIsLeaf, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            this.outputTrackedResult = outputTrackedResult;
            this.children = new ArrayList<String>(children);
            this.childIsLeaf = childIsLeaf;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        public SerializableTestResult getResult() {
            return this.outputTrackedResult.getInnerResult();
        }

        public long getOutputId() {
            return this.outputTrackedResult.getOutputId();
        }

        public List<String> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        public List<SerializedMetadata> getMetadatas() {
            return this.outputTrackedResult.getInnerResult().getMetadatas();
        }

        public void merge(PerRootInfo rootInfo) {
            ImmutableSet knownChildren = ImmutableSet.copyOf(this.children);
            List<String> strings = rootInfo.children;
            for (int i = 0; i < strings.size(); ++i) {
                String newChild = strings.get(i);
                boolean newChildIsLeaf = rootInfo.childIsLeaf.get(i);
                if (!newChildIsLeaf && knownChildren.contains(newChild) && this.isExistingNonLeafChild(newChild)) continue;
                this.children.add(newChild);
                if (!newChildIsLeaf) continue;
                this.childIsLeaf.set(this.children.size() - 1);
            }
            this.totalLeafCount += rootInfo.totalLeafCount;
            this.failedLeafCount += rootInfo.failedLeafCount;
            this.skippedLeafCount += rootInfo.skippedLeafCount;
            SerializableTestResult mergedResult = this.getResult().merge(rootInfo.getResult());
            this.outputTrackedResult = this.outputTrackedResult.withInnerResult(mergedResult);
        }

        private boolean isExistingNonLeafChild(String child) {
            boolean anyNonLeaf = false;
            for (int j = 0; j < this.children.size(); ++j) {
                if (!this.children.get(j).equals(child) || this.childIsLeaf.get(j)) continue;
                anyNonLeaf = true;
                break;
            }
            return anyNonLeaf;
        }
    }
}

