/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.MetaLanguage;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.NaturalComparator;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> NaturalComparator.INSTANCE.compare(o1.getDisplayName(), o2.getDisplayName());
    private static final Key<List<MetaLanguage>> MATCHING_META_LANGUAGES = Key.create("MATCHING_META_LANGUAGES");

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(0);
        }
        return LanguageUtil.getLanguageForPsi(project, file, null);
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file, @Nullable FileType fileType) {
        Language fileLanguage;
        Language explicit;
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            return null;
        }
        Language language2 = explicit = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        Language language3 = explicit != null ? explicit : (fileLanguage = LanguageUtil.getFileTypeLanguage(fileType != null ? fileType : file.getFileType()));
        if (fileLanguage == null) {
            return null;
        }
        for (LanguageSubstitutor substitutor2 : LanguageSubstitutors.getInstance().forKey(Language.ANY)) {
            Language language4 = substitutor2.getLanguage(file, project);
            if (language4 == null || language4 == Language.ANY) continue;
            fileLanguage = language4;
            break;
        }
        return LanguageSubstitutors.getInstance().substituteLanguage(fileLanguage, file, project);
    }

    @Nullable
    public static Language getFileTypeLanguage(@NotNull FileType fileType) {
        if (fileType == null) {
            LanguageUtil.$$$reportNull$$$0(2);
        }
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @NotNull
    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(@NotNull ASTNode left, @NotNull ASTNode right, @NotNull Lexer lexer) {
        if (left == null) {
            LanguageUtil.$$$reportNull$$$0(3);
        }
        if (right == null) {
            LanguageUtil.$$$reportNull$$$0(4);
        }
        if (lexer == null) {
            LanguageUtil.$$$reportNull$$$0(5);
        }
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType() || lexer.getTokenEnd() != left.getTextLength()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(6);
            }
            return spaceRequirements;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length() || lexer.getTokenType() != right.getElementType()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            LanguageUtil.$$$reportNull$$$0(8);
        }
        return spaceRequirements;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language2;
        PsiFile containingFile;
        FileViewProvider provider2;
        Set<Language> languages;
        if (element == null) {
            LanguageUtil.$$$reportNull$$$0(16);
        }
        if ((languages = (provider2 = (containingFile = element.getContainingFile()).getViewProvider()).getLanguages()).size() > 1 && languages.contains(language2 = containingFile.getLanguage())) {
            Language language3 = language2;
            if (language3 == null) {
                LanguageUtil.$$$reportNull$$$0(17);
            }
            return language3;
        }
        Language language4 = provider2.getBaseLanguage();
        if (language4 == null) {
            LanguageUtil.$$$reportNull$$$0(18);
        }
        return language4;
    }

    @NotNull
    static List<MetaLanguage> matchingMetaLanguages(@NotNull Language language2) {
        PersistentList<MetaLanguage> toCache;
        List<MetaLanguage> cached;
        if (language2 == null) {
            LanguageUtil.$$$reportNull$$$0(19);
        }
        if ((cached = language2.getUserData(MATCHING_META_LANGUAGES)) != null) {
            List<MetaLanguage> list = cached;
            if (list == null) {
                LanguageUtil.$$$reportNull$$$0(20);
            }
            return list;
        }
        if (!ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            PersistentList<MetaLanguage> persistentList = ExtensionsKt.persistentListOf();
            if (persistentList == null) {
                LanguageUtil.$$$reportNull$$$0(21);
            }
            return persistentList;
        }
        if (language2 instanceof MetaLanguage) {
            toCache = ExtensionsKt.persistentListOf();
        } else {
            HashSet result2 = new HashSet();
            MetaLanguage.EP_NAME.forEachExtensionSafe(metaLanguage -> {
                if (metaLanguage.matchesLanguage(language2)) {
                    result2.add(metaLanguage);
                }
            });
            toCache = result2.isEmpty() ? ExtensionsKt.persistentListOf() : ExtensionsKt.toPersistentList(result2);
        }
        language2.putUserData(MATCHING_META_LANGUAGES, toCache);
        PersistentList<MetaLanguage> persistentList = toCache;
        if (persistentList == null) {
            LanguageUtil.$$$reportNull$$$0(22);
        }
        return persistentList;
    }

    static void clearMatchingMetaLanguagesCache(@NotNull Language language2) {
        if (language2 == null) {
            LanguageUtil.$$$reportNull$$$0(23);
        }
        language2.putUserData(MATCHING_META_LANGUAGES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langValueText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "canStickTokensTogetherByLexer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDerivedLanguages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootLanguage";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingMetaLanguages";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguages";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canStickTokensTogetherByLexer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllDerivedLanguages";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInTemplateLanguageFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInjectableLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFileLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLanguages";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRootLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "matchingMetaLanguages";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "clearMatchingMetaLanguagesCache";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBaseLanguages";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

