/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.EmptyChildMap;
import org.gradle.internal.snapshot.LargeChildMap;
import org.gradle.internal.snapshot.MediumChildMap;
import org.gradle.internal.snapshot.PathUtil;
import org.gradle.internal.snapshot.SingletonChildMap;

public class ChildMapFactory {
    private static final int MINIMUM_CHILD_COUNT_FOR_BINARY_SEARCH = 10;

    public static <T> ChildMap<T> childMap(CaseSensitivity caseSensitivity, Collection<ChildMap.Entry<T>> entries) {
        ArrayList<ChildMap.Entry<T>> sortedEntries = new ArrayList<ChildMap.Entry<T>>(entries);
        sortedEntries.sort(Comparator.comparing(ChildMap.Entry::getPath, PathUtil.getPathComparator(caseSensitivity)));
        return ChildMapFactory.childMapFromSorted(sortedEntries);
    }

    public static <T> ChildMap<T> childMapFromSorted(List<ChildMap.Entry<T>> sortedEntries) {
        int size = sortedEntries.size();
        switch (size) {
            case 0: {
                return EmptyChildMap.getInstance();
            }
            case 1: {
                return new SingletonChildMap<T>(sortedEntries.get(0));
            }
        }
        return size < 10 ? new MediumChildMap<T>(sortedEntries) : new LargeChildMap<T>(sortedEntries);
    }

    static <T> ChildMap<T> childMap(CaseSensitivity caseSensitivity, ChildMap.Entry<T> entry1, ChildMap.Entry<T> entry2) {
        int compared = PathUtil.getPathComparator(caseSensitivity).compare(entry1.getPath(), entry2.getPath());
        ImmutableList sortedEntries = compared < 0 ? ImmutableList.of(entry1, entry2) : ImmutableList.of(entry2, entry1);
        return ChildMapFactory.childMapFromSorted(sortedEntries);
    }
}

