/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.Multimaps;
import com.google.common.io.Resources;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootTabRenderer;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TabsRenderer;
import org.gradle.util.Path;

final class GenericPageRenderer
extends TabbedPageRenderer<TestTreeModel> {
    private static final URL STYLE_URL = Resources.getResource(GenericPageRenderer.class, (String)"style.css");
    private final List<SerializableTestResultStore.OutputReader> outputReaders;
    private final List<String> rootDisplayNames;
    private final MetadataRendererRegistry metadataRendererRegistry;

    public static String getUrlTo(Path originatingPath, Path targetPath) {
        if (originatingPath.equals((Object)targetPath)) {
            return "#";
        }
        java.nio.file.Path relativePath = Paths.get("./" + GenericHtmlTestReportGenerator.getFilePath(originatingPath), new String[0]).getParent().relativize(Paths.get("./" + GenericHtmlTestReportGenerator.getFilePath(targetPath), new String[0]));
        StringBuilder url = new StringBuilder();
        for (java.nio.file.Path segment : relativePath) {
            url.append(UrlEscapers.urlPathSegmentEscaper().escape(segment.toString()));
            url.append('/');
        }
        return url.substring(0, url.length() - 1);
    }

    GenericPageRenderer(List<SerializableTestResultStore.OutputReader> outputReaders, List<String> rootDisplayNames, MetadataRendererRegistry metadataRendererRegistry) {
        this.outputReaders = outputReaders;
        this.rootDisplayNames = rootDisplayNames;
        this.metadataRendererRegistry = metadataRendererRegistry;
    }

    private void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        if (((TestTreeModel)this.getModel()).getPath().equals((Object)Path.ROOT)) {
            return;
        }
        htmlWriter.startElement("div").attribute("class", "breadcrumbs");
        for (Path path : ((TestTreeModel)this.getModel()).getPath().ancestors()) {
            String title = path.equals((Object)Path.ROOT) ? "all" : path.getName();
            htmlWriter.startElement("a").attribute("class", "breadcrumb").attribute("href", GenericPageRenderer.getUrlTo(((TestTreeModel)this.getModel()).getPath(), path)).characters((CharSequence)title).endElement();
            htmlWriter.characters((CharSequence)" > ");
        }
        htmlWriter.startElement("span").attribute("class", "breadcrumb").characters((CharSequence)((TestTreeModel)this.getModel()).getPath().getName()).endElement();
        htmlWriter.endElement();
    }

    protected URL getStyleUrl() {
        return STYLE_URL;
    }

    protected String getTitle() {
        return this.buildTitle("All Results", name -> "");
    }

    protected String getPageTitle() {
        return this.buildTitle("Test results - All Results", name -> "Test results - " + name);
    }

    private String buildTitle(String rootTitle, Function<String, String> buildTitleFromName) {
        String name = ((TestTreeModel)this.getModel()).getPath().getName();
        if (name == null) {
            return rootTitle;
        }
        return buildTitleFromName.apply(name);
    }

    protected ReportRenderer<TestTreeModel, SimpleHtmlWriter> getHeaderRenderer() {
        return new ReportRenderer<TestTreeModel, SimpleHtmlWriter>(){

            public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
                GenericPageRenderer.this.renderBreadcrumbs(htmlWriter);
            }
        };
    }

    protected ReportRenderer<TestTreeModel, SimpleHtmlWriter> getContentRenderer() {
        TabsRenderer rootTabsRenderer = new TabsRenderer();
        Multimaps.asMap(((TestTreeModel)this.getModel()).getPerRootInfo()).forEach((rootIndex, infos) -> {
            TabsRenderer directlyBelowRootTabsRenderer;
            ArrayList<TabsRenderer> perRootInfoTabsRenderers = new ArrayList<TabsRenderer>(infos.size());
            for (int perRootInfoIndex = 0; perRootInfoIndex < infos.size(); ++perRootInfoIndex) {
                TestTreeModel.PerRootInfo info = (TestTreeModel.PerRootInfo)infos.get(perRootInfoIndex);
                TabsRenderer perRootInfoTabsRenderer = new TabsRenderer();
                perRootInfoTabsRenderer.add("summary", (ReportRenderer)new PerRootTabRenderer.ForSummary((int)rootIndex, perRootInfoIndex));
                SerializableTestResultStore.OutputReader outputReader = this.outputReaders.get((int)rootIndex);
                if (outputReader.hasOutput(info.getOutputId(), TestOutputEvent.Destination.StdOut)) {
                    perRootInfoTabsRenderer.add("standard output", (ReportRenderer)new PerRootTabRenderer.ForOutput((int)rootIndex, perRootInfoIndex, outputReader, TestOutputEvent.Destination.StdOut));
                }
                if (outputReader.hasOutput(info.getOutputId(), TestOutputEvent.Destination.StdErr)) {
                    perRootInfoTabsRenderer.add("error output", (ReportRenderer)new PerRootTabRenderer.ForOutput((int)rootIndex, perRootInfoIndex, outputReader, TestOutputEvent.Destination.StdErr));
                }
                if (!info.getMetadatas().isEmpty()) {
                    perRootInfoTabsRenderer.add("metadata", (ReportRenderer)new PerRootTabRenderer.ForMetadata((int)rootIndex, perRootInfoIndex, this.metadataRendererRegistry));
                }
                perRootInfoTabsRenderers.add(perRootInfoTabsRenderer);
            }
            if (perRootInfoTabsRenderers.size() == 1) {
                directlyBelowRootTabsRenderer = (TabsRenderer)perRootInfoTabsRenderers.get(0);
            } else {
                directlyBelowRootTabsRenderer = new TabsRenderer();
                for (int i = 0; i < perRootInfoTabsRenderers.size(); ++i) {
                    directlyBelowRootTabsRenderer.add("run " + (i + 1), (ReportRenderer)perRootInfoTabsRenderers.get(i));
                }
            }
            rootTabsRenderer.add(this.rootDisplayNames.get((int)rootIndex), (ReportRenderer)new ReportRenderer<TestTreeModel, SimpleHtmlWriter>(){

                public void render(TestTreeModel model, SimpleHtmlWriter output) throws IOException {
                    output.startElement("h1").characters((CharSequence)((TestTreeModel.PerRootInfo)infos.get(0)).getResult().getDisplayName()).endElement();
                    directlyBelowRootTabsRenderer.render((Object)model, output);
                }
            });
        });
        return rootTabsRenderer;
    }
}

