/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.util.Optional;
import java.util.function.LongFunction;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.testing.GroupTestEventReporterInternal;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestEventReporterFactory;
import org.gradle.internal.event.ListenerBroadcast;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface TestEventReporterFactoryInternal
extends TestEventReporterFactory {
    public GroupTestEventReporterInternal createInternalTestEventReporter(LongFunction<TestDescriptorInternal> var1, Directory var2, @Nullable TestReportGenerator var3, ListenerBroadcast<TestListenerInternal> var4, int var5, boolean var6);

    public static interface TestReportResult {
        public static TestReportResult failureReported() {
            return FailureReported.INSTANCE;
        }

        public static TestReportResult testFailureDetected(String failureMessage) {
            return new TestFailureDetected(failureMessage);
        }

        public static TestReportResult noAction() {
            return NoAction.INSTANCE;
        }

        public static TestReportResult failuresIgnored() {
            return FailuresIgnored.INSTANCE;
        }

        public static TestReportResult noTestsRun(String failureMessage) {
            return new NoTestsRun(failureMessage);
        }

        default public Optional<String> getFailureMessage() {
            return Optional.empty();
        }

        default public boolean shouldFailTask() {
            return false;
        }

        public static final class FailureReported
        implements TestReportResult {
            private static final FailureReported INSTANCE = new FailureReported();

            private FailureReported() {
            }

            public String toString() {
                return "FAILURE_REPORTED";
            }
        }

        public static final class TestFailureDetected
        implements TestReportResult {
            private final String failureMessage;

            private TestFailureDetected(String failureMessage) {
                if (failureMessage == null || failureMessage.isEmpty()) {
                    throw new IllegalArgumentException("Failure message must not be null or empty");
                }
                this.failureMessage = failureMessage;
            }

            @Override
            public Optional<String> getFailureMessage() {
                return Optional.of(this.failureMessage);
            }

            public String toString() {
                return "TEST_FAILURE_DETECTED[failureMessage=" + this.failureMessage + "]";
            }

            @Override
            public boolean shouldFailTask() {
                return true;
            }
        }

        public static final class NoAction
        implements TestReportResult {
            private static final NoAction INSTANCE = new NoAction();

            private NoAction() {
            }

            public String toString() {
                return "NO_ACTION";
            }
        }

        @NullMarked
        public static final class FailuresIgnored
        implements TestReportResult {
            private static final FailuresIgnored INSTANCE = new FailuresIgnored();

            private FailuresIgnored() {
            }

            public String toString() {
                return "FAILURES_IGNORED";
            }
        }

        @NullMarked
        public static final class NoTestsRun
        implements TestReportResult {
            private final String failureMessage;

            private NoTestsRun(String failureMessage) {
                if (failureMessage == null || failureMessage.isEmpty()) {
                    throw new IllegalArgumentException("Failure message must not be null or empty");
                }
                this.failureMessage = failureMessage;
            }

            @Override
            public Optional<String> getFailureMessage() {
                return Optional.of(this.failureMessage);
            }

            public String toString() {
                return "NO_TESTS_RUN";
            }

            @Override
            public boolean shouldFailTask() {
                return true;
            }
        }
    }
}

