/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.junit.result.AggregateTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.BinaryResultBackedTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.HtmlTestReport;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LegacyHtmlTestReportGenerator
implements TestReportGenerator {
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Path reportsDirectory;

    private static TestResultsProvider createAggregateProvider(List<Path> resultDirs) {
        if (resultDirs.size() == 1) {
            File singleFile = resultDirs.get(0).toFile();
            return new BinaryResultBackedTestResultsProvider(singleFile);
        }
        LinkedList resultsProviders = new LinkedList();
        try {
            return new AggregateTestResultsProvider(CollectionUtils.collect(resultDirs, resultsProviders, p -> new BinaryResultBackedTestResultsProvider(p.toFile())));
        }
        catch (RuntimeException e) {
            CompositeStoppable.stoppable(resultsProviders).stop();
            throw e;
        }
    }

    @Inject
    public LegacyHtmlTestReportGenerator(BuildOperationRunner buildOperationRunner, BuildOperationExecutor buildOperationExecutor, Path reportsDirectory) {
        this.buildOperationRunner = buildOperationRunner;
        this.buildOperationExecutor = buildOperationExecutor;
        this.reportsDirectory = reportsDirectory;
    }

    @Override
    public Path generate(List<Path> resultsDirectories) {
        Path path;
        block8: {
            TestResultsProvider provider = LegacyHtmlTestReportGenerator.createAggregateProvider(resultsDirectories);
            try {
                HtmlTestReport testReport = new HtmlTestReport(this.buildOperationRunner, this.buildOperationExecutor);
                testReport.generateReport(provider, this.reportsDirectory.toFile());
                path = this.reportsDirectory.resolve("index.html");
                if (provider == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (provider != null) {
                        try {
                            provider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read test results", e);
                }
            }
            provider.close();
        }
        return path;
    }
}

