/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import com.esotericsoftware.kryo.io.Output;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.StringEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringEncoder;", "Lorg/gradle/internal/serialize/graph/StringEncoder;", "stream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "strings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "nextId", "output", "Lcom/esotericsoftware/kryo/io/Output;", "writeNullableString", "", "encoder", "Lorg/gradle/internal/serialize/Encoder;", "string", "", "writeString", "close", "doWriteString", "Companion", "configuration-cache"})
public final class ParallelStringEncoder
implements StringEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, Integer> strings;
    private int nextId;
    @NotNull
    private final Output output;
    public static final int NULL_STRING_ID = 0;
    public static final int EMPTY_STRING_ID = 1;
    public static final int FIRST_STRING_ID = 2;

    public ParallelStringEncoder(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.strings = new ConcurrentHashMap();
        this.nextId = 2;
        this.output = new Output(stream);
    }

    public void writeNullableString(@NotNull Encoder encoder, @Nullable CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        if (string == null) {
            encoder.writeSmallInt(0);
        } else {
            this.writeString(encoder, string);
        }
    }

    public void writeString(@NotNull Encoder encoder, @NotNull CharSequence string) {
        int n;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (string.length() == 0) {
            n = 1;
        } else {
            Integer n2 = this.strings.computeIfAbsent(((Object)string).toString(), new Function(this){
                final /* synthetic */ ParallelStringEncoder $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final Integer apply(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ParallelStringEncoder.access$doWriteString(this.$tmp0, p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"computeIfAbsent(...)");
            n = ((Number)n2).intValue();
        }
        encoder.writeSmallInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Output output = this.output;
        synchronized (output) {
            boolean bl = false;
            this.output.writeString("");
            this.output.close();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doWriteString(String string) {
        int n;
        Output output = this.output;
        synchronized (output) {
            boolean bl = false;
            this.output.writeString(string);
            int n2 = this.nextId;
            this.nextId = n2 + 1;
            n = n2;
        }
        return n;
    }

    public static final /* synthetic */ int access$doWriteString(ParallelStringEncoder $this, String string) {
        return $this.doWriteString(string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringEncoder$Companion;", "", "<init>", "()V", "NULL_STRING_ID", "", "EMPTY_STRING_ID", "FIRST_STRING_ID", "configuration-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

