/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.model;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.jspecify.annotations.Nullable;

public class Checksum {
    private final ChecksumKind kind;
    private final String value;
    private final Set<String> alternatives;
    private final String origin;
    private final String reason;
    private final int hashCode;

    public Checksum(ChecksumKind kind, String value, @Nullable Set<String> alternatives, @Nullable String origin, @Nullable String reason) {
        this.kind = kind;
        this.value = value;
        this.alternatives = alternatives == null ? null : ImmutableSet.copyOf(alternatives);
        this.origin = origin;
        this.reason = reason;
        this.hashCode = this.computeHashcode();
    }

    private int computeHashcode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (this.alternatives != null ? this.alternatives.hashCode() : 0);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
        return result;
    }

    public ChecksumKind getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    public @Nullable Set<String> getAlternatives() {
        return this.alternatives;
    }

    public @Nullable String getOrigin() {
        return this.origin;
    }

    public @Nullable String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checksum checksum = (Checksum)o;
        if (this.kind != checksum.kind) {
            return false;
        }
        if (!this.value.equals(checksum.value)) {
            return false;
        }
        if (!Objects.equals(this.alternatives, checksum.alternatives)) {
            return false;
        }
        if (!Objects.equals(this.origin, checksum.origin)) {
            return false;
        }
        return Objects.equals(this.reason, checksum.reason);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

