/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.Instrumented;
import org.jspecify.annotations.Nullable;

public class FileUtils {
    public static boolean optionsAllowReading(OpenOption[] options) {
        boolean hasNonReadMode = false;
        for (OpenOption option : options) {
            if (option == StandardOpenOption.READ) {
                return true;
            }
            if (option != StandardOpenOption.APPEND && option != StandardOpenOption.WRITE) continue;
            hasNonReadMode = true;
        }
        return !hasNonReadMode;
    }

    public static boolean optionsAllowReading(Set<?> options) {
        return FileUtils.optionsAllowReading(((Set)Cast.uncheckedNonnullCast(options)).toArray(new OpenOption[0]));
    }

    public static void tryReportFileOpened(Path path, String consumer) {
        File file = FileUtils.toFileIfAvailable(path);
        if (file != null) {
            Instrumented.fileOpened(file, consumer);
        }
    }

    public static void tryReportDirectoryContentObserved(Path path, String consumer) {
        File file = FileUtils.toFileIfAvailable(path);
        if (file != null) {
            Instrumented.directoryContentObserved(file, consumer);
        }
    }

    public static void tryReportFileSystemEntryObserved(Path path, String consumer) {
        File file = FileUtils.toFileIfAvailable(path);
        if (file != null) {
            Instrumented.fileSystemEntryObserved(file, consumer);
        }
    }

    private static @Nullable File toFileIfAvailable(Path path) {
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return path.toFile();
        }
        return null;
    }
}

