/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.compiler.java.listeners.constants;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.gradle.internal.compiler.java.listeners.constants.ConstantDependentsConsumer;
import org.gradle.internal.compiler.java.listeners.constants.ConstantsVisitorContext;

public class ConstantsTreeVisitor
extends TreePathScanner<ConstantsVisitorContext, ConstantsVisitorContext> {
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final String PACKAGE_INFO = "package-info";
    private static final String MODULE_INFO = "module-info";
    private final Elements elements;
    private final Trees trees;
    private final ConstantDependentsConsumer consumer;

    public ConstantsTreeVisitor(Elements elements, Trees trees, ConstantDependentsConsumer consumer) {
        this.elements = elements;
        this.trees = trees;
        this.consumer = consumer;
    }

    @Override
    public ConstantsVisitorContext visitCompilationUnit(CompilationUnitTree node, ConstantsVisitorContext context) {
        String sourceName = node.getSourceFile().getName();
        if (sourceName.endsWith(PACKAGE_INFO_JAVA)) {
            PackageElement packageElement = this.elements.getPackageOf(this.trees.getElement(this.getCurrentPath()));
            String visitedPackageInfo = packageElement == null || packageElement.getQualifiedName().toString().isEmpty() ? PACKAGE_INFO : packageElement.getQualifiedName().toString() + "." + PACKAGE_INFO;
            return (ConstantsVisitorContext)super.visitCompilationUnit(node, new ConstantsVisitorContext(visitedPackageInfo, this.consumer::consumeAccessibleDependent));
        }
        return (ConstantsVisitorContext)super.visitCompilationUnit(node, context);
    }

    @Override
    public ConstantsVisitorContext visitModule(ModuleTree node, ConstantsVisitorContext context) {
        super.visitModule(node, new ConstantsVisitorContext(MODULE_INFO, this.consumer::consumeAccessibleDependent));
        return context;
    }

    @Override
    public ConstantsVisitorContext visitClass(ClassTree node, ConstantsVisitorContext context) {
        Element element = this.trees.getElement(this.getCurrentPath());
        String visitedClass = this.getBinaryClassName((TypeElement)element);
        super.visitClass(node, new ConstantsVisitorContext(visitedClass, this.consumer::consumePrivateDependent));
        return context;
    }

    @Override
    public ConstantsVisitorContext visitVariable(VariableTree node, ConstantsVisitorContext context) {
        if (this.isAccessibleConstantVariableDeclaration(node) && node.getInitializer() != null && !(node.getInitializer() instanceof MethodInvocationTree)) {
            return (ConstantsVisitorContext)super.visitVariable(node, new ConstantsVisitorContext(context.getVisitedClass(), this.consumer::consumeAccessibleDependent));
        }
        return (ConstantsVisitorContext)super.visitVariable(node, context);
    }

    private boolean isAccessibleConstantVariableDeclaration(VariableTree node) {
        Set<Modifier> modifiers = node.getModifiers().getFlags();
        return modifiers.contains((Object)Modifier.FINAL) && modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    @Override
    public ConstantsVisitorContext visitMemberSelect(MemberSelectTree node, ConstantsVisitorContext context) {
        Element element = this.trees.getElement(this.getCurrentPath());
        if (this.isPrimitiveConstantVariable(element)) {
            context.addConstantOrigin(this.getBinaryClassName(Objects.requireNonNull((TypeElement)element.getEnclosingElement())));
        }
        return (ConstantsVisitorContext)super.visitMemberSelect(node, context);
    }

    @Override
    public ConstantsVisitorContext visitIdentifier(IdentifierTree node, ConstantsVisitorContext context) {
        Element element = this.trees.getElement(this.getCurrentPath());
        if (this.isPrimitiveConstantVariable(element)) {
            context.addConstantOrigin(this.getBinaryClassName(Objects.requireNonNull((TypeElement)element.getEnclosingElement())));
        }
        return (ConstantsVisitorContext)super.visitIdentifier(node, context);
    }

    private String getBinaryClassName(TypeElement typeElement) {
        if (typeElement.getNestingKind().isNested()) {
            return this.elements.getBinaryName(typeElement).toString();
        }
        return typeElement.getQualifiedName().toString();
    }

    private boolean isPrimitiveConstantVariable(Element element) {
        return element instanceof VariableElement && element.getEnclosingElement() instanceof TypeElement && ((VariableElement)element).getConstantValue() != null;
    }
}

