/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.file.FileTree;
import org.gradle.buildinit.plugins.internal.ConditionalTemplateOperation;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.internal.Factory;
import org.jspecify.annotations.Nullable;

public class TemplateFactory {
    private final TemplateOperationFactory templateOperationFactory;
    private final InitSettings initSettings;
    private final Language language;

    public TemplateFactory(InitSettings initSettings, Language language, TemplateOperationFactory templateOperationFactory) {
        this.initSettings = initSettings;
        this.language = language;
        this.templateOperationFactory = templateOperationFactory;
    }

    public TemplateOperation whenNoSourcesAvailable(TemplateOperation ... operations) {
        return this.whenNoSourcesAvailable(this.initSettings.getSubprojects().get(0), Arrays.asList(operations));
    }

    public TemplateOperation whenNoSourcesAvailable(String subproject, List<TemplateOperation> operations) {
        return new ConditionalTemplateOperation((Factory<Boolean>)((Factory)() -> {
            FileTree mainFiles = this.initSettings.getTarget().dir(subproject + "/src/main/" + this.language.getName()).getAsFileTree();
            FileTree testFiles = this.initSettings.getTarget().dir(subproject + "/src/test/" + this.language.getName()).getAsFileTree();
            return mainFiles.isEmpty() || testFiles.isEmpty();
        }), operations);
    }

    public TemplateOperation fromSourceTemplate(String clazzTemplate, String sourceSetName) {
        return this.fromSourceTemplate(clazzTemplate, sourceSetName, this.initSettings.getSubprojects().get(0), this.language);
    }

    public TemplateOperation fromSourceTemplate(String clazzTemplate, String sourceSetName, String subprojectName) {
        return this.fromSourceTemplate(clazzTemplate, sourceSetName, subprojectName, this.language);
    }

    public TemplateOperation fromSourceTemplate(String clazzTemplate, String sourceSetName, String subprojectName, Language language) {
        return this.fromSourceTemplate(clazzTemplate, (Action<? super SourceFileTemplate>)((Action)t -> {
            t.subproject(subprojectName);
            t.sourceSet(sourceSetName);
            t.language(language);
        }));
    }

    public TemplateOperation fromSourceTemplate(String sourceTemplate, Action<? super SourceFileTemplate> config) {
        String className;
        String targetFileName = sourceTemplate.substring(sourceTemplate.lastIndexOf("/") + 1).replace(".template", "");
        TemplateDetails details = new TemplateDetails(this.language, targetFileName);
        config.execute((Object)details);
        String basePackageName = "";
        String packageDecl = "";
        String string = className = details.className == null ? "" : details.className;
        if (this.initSettings != null) {
            String packageName = basePackageName = this.initSettings.getPackageName();
            if (this.initSettings.getModularizationOption() == ModularizationOption.WITH_LIBRARY_PROJECTS) {
                packageName = TemplateFactory.joinIfNotEmpty(packageName, ".") + details.subproject;
            }
            packageDecl = TemplateFactory.joinIfNotEmpty("package ", packageName);
            targetFileName = TemplateFactory.joinIfNotEmpty(packageName.replace(".", "/"), "/") + details.getTargetFileName();
        } else {
            targetFileName = details.getTargetFileName();
        }
        TemplateOperationFactory.TemplateOperationBuilder operationBuilder = this.templateOperationFactory.newTemplateOperation().withTemplate(sourceTemplate).withTarget(this.initSettings.getTarget().file(details.subproject + "/src/" + details.sourceSet + "/" + details.language.getName() + "/" + targetFileName).getAsFile()).withBinding("basePackagePrefix", TemplateFactory.joinIfNotEmpty(basePackageName, ".")).withBinding("packageDecl", packageDecl).withBinding("className", className).withBinding("fileComment", this.initSettings.isWithComments() ? "This source file was generated by the Gradle 'init' task" : "");
        for (Map.Entry<String, String> entry : details.bindings.entrySet()) {
            operationBuilder.withBinding(entry.getKey(), entry.getValue());
        }
        return operationBuilder.create();
    }

    private static String joinIfNotEmpty(String left, String right) {
        return left.isEmpty() || right.isEmpty() ? "" : left + right;
    }

    private static class TemplateDetails
    implements SourceFileTemplate {
        final Map<String, String> bindings = new HashMap<String, String>();
        String subproject;
        String sourceSet = "main";
        Language language;
        String fileName;
        @Nullable String className;

        TemplateDetails(Language language, String fileName) {
            this.language = language;
            this.fileName = fileName;
        }

        @Override
        public void subproject(String subproject) {
            this.subproject = subproject;
        }

        @Override
        public void sourceSet(String name) {
            this.sourceSet = name;
        }

        @Override
        public void language(Language language) {
            this.language = language;
        }

        @Override
        public void className(String name) {
            this.className = name;
        }

        @Override
        public void binding(String name, String value) {
            this.bindings.put(name, value);
        }

        public String getTargetFileName() {
            if (this.className != null) {
                return this.className + "." + this.language.getExtension();
            }
            return this.fileName;
        }
    }

    protected static interface SourceFileTemplate {
        public void sourceSet(String var1);

        public void language(Language var1);

        public void className(String var1);

        public void binding(String var1, String var2);

        public void subproject(String var1);
    }
}

