/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.execution.ResolveTaskMutationsBuildOperationType;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.ServiceReferenceSpec;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchies;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resources.ResourceLock;
import org.jspecify.annotations.Nullable;

public class ResolveMutationsNode
extends Node
implements SelfExecutingNode {
    private final LocalTaskNode node;
    private final NodeValidator nodeValidator;
    private final BuildOperationRunner buildOperationRunner;
    private final ExecutionNodeAccessHierarchies accessHierarchies;
    private Exception failure;
    private static final ResolveTaskMutationsBuildOperationType.Result RESOLVE_TASK_MUTATIONS_RESULT = new ResolveTaskMutationsBuildOperationType.Result(){};

    public ResolveMutationsNode(LocalTaskNode node, NodeValidator nodeValidator, BuildOperationRunner buildOperationRunner, ExecutionNodeAccessHierarchies accessHierarchies) {
        this.node = node;
        this.nodeValidator = nodeValidator;
        this.buildOperationRunner = buildOperationRunner;
        this.accessHierarchies = accessHierarchies;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "Resolve mutations for " + this.node;
    }

    @Override
    public @Nullable Throwable getNodeFailure() {
        return this.failure;
    }

    @Override
    public boolean isCanCancel() {
        return this.node.isCanCancel();
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
    }

    @Override
    public @Nullable ResourceLock getProjectToLock() {
        return this.node.getProjectToLock();
    }

    @Override
    public @Nullable ProjectInternal getOwningProject() {
        return this.node.getOwningProject();
    }

    @Override
    public void execute(NodeExecutionContext context) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                try {
                    MutationInfo mutations = ResolveMutationsNode.this.resolveAndValidateMutations();
                    mutations.getOutputPaths().forEach(outputPath -> ResolveMutationsNode.this.accessHierarchies.getOutputHierarchy().recordNodeAccessingLocation(ResolveMutationsNode.this.node, (String)outputPath));
                    mutations.getDestroyablePaths().forEach(destroyablePath -> ResolveMutationsNode.this.accessHierarchies.getDestroyableHierarchy().recordNodeAccessingLocation(ResolveMutationsNode.this.node, (String)destroyablePath));
                    ResolveMutationsNode.this.node.mutationsResolved(mutations);
                    context.setResult((Object)RESOLVE_TASK_MUTATIONS_RESULT);
                }
                catch (Exception e) {
                    ResolveMutationsNode.this.failure = e;
                    context.failed((Throwable)ResolveMutationsNode.this.failure);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                TaskIdentity<?> taskIdentity = ResolveMutationsNode.this.node.getTask().getTaskIdentity();
                return BuildOperationDescriptor.displayName((String)("Resolve mutations for task " + taskIdentity.getBuildTreePath().asString())).details((Object)new ResolveTaskMutationsDetails(taskIdentity));
            }
        });
    }

    private MutationInfo resolveAndValidateMutations() {
        MutationInfo mutations;
        boolean hasValidationProblem = this.nodeValidator.hasValidationProblems(this.node);
        try {
            TaskProperties taskProperties = this.node.getTaskProperties();
            mutations = ResolveMutationsNode.resolveMutations(taskProperties, hasValidationProblem);
            this.node.getTask().acceptServiceReferences((Set<ServiceReferenceSpec>)taskProperties.getServiceReferences());
        }
        catch (Exception e) {
            throw new TaskExecutionException(this.node.getTask(), e);
        }
        this.validateMutations(mutations);
        return mutations;
    }

    private static MutationInfo resolveMutations(TaskProperties taskProperties, boolean hasValidationProblem) {
        boolean hasOutputs = false;
        boolean hasLocalState = false;
        ImmutableSet.Builder outputPaths = ImmutableSet.builder();
        ImmutableSet.Builder destroyablePaths = ImmutableSet.builder();
        for (OutputFilePropertySpec spec : taskProperties.getOutputFileProperties()) {
            File outputLocation = spec.getOutputFile();
            outputPaths.add((Object)outputLocation.getAbsolutePath());
            hasOutputs = true;
        }
        for (File file : taskProperties.getLocalStateFiles()) {
            outputPaths.add((Object)file.getAbsolutePath());
            hasLocalState = true;
        }
        for (File file : taskProperties.getDestroyableFiles()) {
            destroyablePaths.add((Object)file.getAbsolutePath());
        }
        boolean hasFileInputs = !taskProperties.getInputFileProperties().isEmpty();
        return new MutationInfo((ImmutableSet<String>)outputPaths.build(), (ImmutableSet<String>)destroyablePaths.build(), hasFileInputs, hasOutputs, hasLocalState, hasValidationProblem);
    }

    private void validateMutations(MutationInfo mutations) {
        if (!mutations.getDestroyablePaths().isEmpty()) {
            if (mutations.hasOutputs()) {
                throw new IllegalStateException("Task " + this.node + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
            }
            if (mutations.hasFileInputs()) {
                throw new IllegalStateException("Task " + this.node + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
            }
            if (mutations.hasLocalState()) {
                throw new IllegalStateException("Task " + this.node + " has both local state and destroyables defined.  A task can define either local state or destroyables, but not both.");
            }
        }
    }

    private static final class ResolveTaskMutationsDetails
    implements ResolveTaskMutationsBuildOperationType.Details {
        private final TaskIdentity<?> taskIdentity;

        public ResolveTaskMutationsDetails(TaskIdentity<?> taskIdentity) {
            this.taskIdentity = taskIdentity;
        }

        public String getBuildPath() {
            return this.taskIdentity.getProjectIdentity().getBuildPath().asString();
        }

        public String getTaskPath() {
            return this.taskIdentity.getPath().asString();
        }

        public long getTaskId() {
            return this.taskIdentity.getId();
        }
    }
}

