/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ArtifactSelectionDetails;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleDependencyCapabilitiesHandler;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantSelectionDetails;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableModuleDependencyCapabilitiesHandler;
import org.gradle.api.internal.artifacts.dependencies.ModuleDependencyCapabilitiesInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ArtifactSelectionDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencyResolveDetails;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.Describables;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.util.Path;

public class DefaultDependencySubstitutions
implements DependencySubstitutionsInternal {
    private final NotationParser<Object, ComponentSelector> moduleSelectorNotationParser;
    private final NotationParser<Object, ComponentSelector> projectSelectorNotationParser;
    private final ComponentSelectionDescriptor reason;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final AttributesFactory attributesFactory;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private ImmutableActionSet<DependencySubstitution> substitutionRules;
    private boolean rulesMayAddProjectDependency;

    public static DefaultDependencySubstitutions forResolutionStrategy(BuildState build, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, Instantiator instantiator, ObjectFactory objectFactory, AttributesFactory attributesFactory, NotationParser<Object, Capability> capabilityNotationParser) {
        NotationParser<Object, ComponentSelector> projectSelectorNotationParser = DefaultDependencySubstitutions.notationParserFor(build);
        return (DefaultDependencySubstitutions)instantiator.newInstance(DefaultDependencySubstitutions.class, new Object[]{ComponentSelectionReasons.SELECTED_BY_RULE, projectSelectorNotationParser, moduleSelectorNotationParser, instantiator, objectFactory, attributesFactory, capabilityNotationParser});
    }

    public static DefaultDependencySubstitutions forIncludedBuild(IncludedBuildState build, Instantiator instantiator, ObjectFactory objectFactory, AttributesFactory attributesFactory, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, NotationParser<Object, Capability> capabilityNotationParser) {
        NotationParser<Object, ComponentSelector> projectSelectorNotationParser = DefaultDependencySubstitutions.notationParserFor((BuildState)build);
        return (DefaultDependencySubstitutions)instantiator.newInstance(CompositeBuildAwareSubstitutions.class, new Object[]{projectSelectorNotationParser, moduleSelectorNotationParser, instantiator, objectFactory, attributesFactory, capabilityNotationParser});
    }

    private static NotationParser<Object, ComponentSelector> notationParserFor(BuildState build) {
        return NotationParserBuilder.toType(ComponentSelector.class).fromCharSequence((NotationConverter)new ProjectPathConverter(build)).toComposite();
    }

    @Inject
    public DefaultDependencySubstitutions(ComponentSelectionDescriptor reason, NotationParser<Object, ComponentSelector> projectSelectorNotationParser, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, Instantiator instantiator, ObjectFactory objectFactory, AttributesFactory attributesFactory, NotationParser<Object, Capability> capabilityNotationParser) {
        this(reason, (ImmutableActionSet<DependencySubstitution>)ImmutableActionSet.empty(), moduleSelectorNotationParser, projectSelectorNotationParser, instantiator, objectFactory, attributesFactory, capabilityNotationParser);
    }

    private DefaultDependencySubstitutions(ComponentSelectionDescriptor reason, ImmutableActionSet<DependencySubstitution> substitutionRules, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, NotationParser<Object, ComponentSelector> projectSelectorNotationParser, Instantiator instantiator, ObjectFactory objectFactory, AttributesFactory attributesFactory, NotationParser<Object, Capability> capabilityNotationParser) {
        this.reason = reason;
        this.substitutionRules = substitutionRules;
        this.moduleSelectorNotationParser = moduleSelectorNotationParser;
        this.projectSelectorNotationParser = projectSelectorNotationParser;
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.capabilityNotationParser = capabilityNotationParser;
    }

    @Override
    public void discard() {
        this.substitutionRules = ImmutableActionSet.empty();
        this.rulesMayAddProjectDependency = false;
    }

    @Override
    public boolean rulesMayAddProjectDependency() {
        return this.rulesMayAddProjectDependency;
    }

    @Override
    public Action<DependencySubstitution> getRuleAction() {
        return this.substitutionRules;
    }

    protected void addSubstitution(Action<? super DependencySubstitution> rule, boolean projectInvolved) {
        this.addRule(rule);
        if (projectInvolved) {
            this.rulesMayAddProjectDependency = true;
        }
    }

    private void addRule(Action<? super DependencySubstitution> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.substitutionRules = this.substitutionRules.add(rule);
    }

    public DependencySubstitutions all(Action<? super DependencySubstitution> rule) {
        this.addRule(rule);
        this.rulesMayAddProjectDependency = true;
        return this;
    }

    @Override
    public DependencySubstitutions allWithDependencyResolveDetails(Action<? super DependencyResolveDetails> rule, ComponentSelectorConverter componentSelectorConverter) {
        this.addRule(new DependencyResolveDetailsWrapperAction(rule, componentSelectorConverter, Actions::doNothing, this.instantiator));
        return this;
    }

    public ComponentSelector module(String notation) {
        return (ComponentSelector)this.moduleSelectorNotationParser.parseNotation((Object)notation);
    }

    public ComponentSelector project(String path) {
        return (ComponentSelector)this.projectSelectorNotationParser.parseNotation((Object)path);
    }

    public ComponentSelector platform(ComponentSelector selector) {
        return this.variant(selector, (Action<? super VariantSelectionDetails>)((Action)VariantSelectionDetails::platform));
    }

    public ComponentSelector variant(ComponentSelector selector, Action<? super VariantSelectionDetails> detailsAction) {
        DefaultVariantSelectionDetails details = (DefaultVariantSelectionDetails)this.instantiator.newInstance(DefaultVariantSelectionDetails.class, new Object[]{this.attributesFactory, this.objectFactory, this.capabilityNotationParser, selector});
        detailsAction.execute((Object)details);
        return details.selector;
    }

    public DependencySubstitutions.Substitution substitute(final ComponentSelector substituted) {
        return new DependencySubstitutions.Substitution(){
            Action<? super ArtifactSelectionDetails> artifactAction = Actions.doNothing();
            ComponentSelectionDescriptorInternal substitutionReason = (ComponentSelectionDescriptorInternal)DefaultDependencySubstitutions.access$200(DefaultDependencySubstitutions.this);

            public DependencySubstitutions.Substitution because(String description) {
                this.substitutionReason = this.substitutionReason.withDescription((Describable)Describables.of((Object)description));
                return this;
            }

            public DependencySubstitutions.Substitution withClassifier(String classifier) {
                this.artifactAction = Actions.composite((Action[])new Action[]{this.artifactAction, new SetClassifier(classifier)});
                return this;
            }

            public DependencySubstitutions.Substitution withoutClassifier() {
                this.artifactAction = Actions.composite((Action[])new Action[]{this.artifactAction, NoClassifier.INSTANCE});
                return this;
            }

            public DependencySubstitutions.Substitution withoutArtifactSelectors() {
                this.artifactAction = Actions.composite((Action[])new Action[]{this.artifactAction, NoArtifactSelector.INSTANCE});
                return this;
            }

            public DependencySubstitutions.Substitution using(ComponentSelector notation) {
                boolean projectInvolved;
                DefaultDependencySubstitution.validateTarget(notation);
                boolean bl = projectInvolved = substituted instanceof ProjectComponentSelector || notation instanceof ProjectComponentSelector;
                if (substituted instanceof UnversionedModuleComponentSelector) {
                    ModuleIdentifier moduleId = ((UnversionedModuleComponentSelector)substituted).getModuleIdentifier();
                    if (notation instanceof ModuleComponentSelector && ((ModuleComponentSelector)notation).getModuleIdentifier().equals(moduleId)) {
                        this.substitutionReason = this.substitutionReason.markAsEquivalentToForce();
                    }
                    DefaultDependencySubstitutions.this.addSubstitution(new ModuleMatchDependencySubstitutionAction(this.substitutionReason, moduleId, notation, () -> this.artifactAction), projectInvolved);
                } else {
                    DefaultDependencySubstitutions.this.addSubstitution(new ExactMatchDependencySubstitutionAction(this.substitutionReason, substituted, notation, () -> this.artifactAction), projectInvolved);
                }
                return this;
            }
        };
    }

    @Override
    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    @Override
    public DependencySubstitutionsInternal copy() {
        return new DefaultDependencySubstitutions(this.reason, this.substitutionRules, this.moduleSelectorNotationParser, this.projectSelectorNotationParser, this.instantiator, this.objectFactory, this.attributesFactory, this.capabilityNotationParser);
    }

    static /* synthetic */ ComponentSelectionDescriptor access$200(DefaultDependencySubstitutions x0) {
        return x0.reason;
    }

    public static class CompositeBuildAwareSubstitutions
    extends DefaultDependencySubstitutions {
        @Inject
        public CompositeBuildAwareSubstitutions(NotationParser<Object, ComponentSelector> projectSelectorNotationParser, NotationParser<Object, ComponentSelector> moduleIdentifierFactory, Instantiator instantiator, ObjectFactory objectFactory, AttributesFactory attributesFactory, NotationParser<Object, Capability> capabilityNotationParser) {
            super(ComponentSelectionReasons.COMPOSITE_BUILD, projectSelectorNotationParser, moduleIdentifierFactory, instantiator, objectFactory, attributesFactory, capabilityNotationParser);
        }

        @Override
        protected void addSubstitution(Action<? super DependencySubstitution> rule, boolean projectInvolved) {
            CompositeBuildSubstitutionAction decorated = new CompositeBuildSubstitutionAction(rule);
            super.addSubstitution(decorated, projectInvolved);
        }
    }

    private static class ProjectPathConverter
    implements NotationConverter<String, ProjectComponentSelector> {
        private final BuildState build;

        private ProjectPathConverter(BuildState build) {
            this.build = build;
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Project paths, e.g. ':api'.");
        }

        public void convert(String notation, NotationConvertResult<? super ProjectComponentSelector> result) throws TypeConversionException {
            ProjectIdentity id = this.build.getProjects().getProject(Path.path((String)notation)).getIdentity();
            result.converted((Object)new DefaultProjectComponentSelector(id, ImmutableAttributes.EMPTY, (ImmutableSet<CapabilitySelector>)ImmutableSet.of()));
        }
    }

    private static class DependencyResolveDetailsWrapperAction
    extends AbstractDependencySubstitutionAction {
        private final Action<? super DependencyResolveDetails> delegate;
        private final ComponentSelectorConverter componentSelectorConverter;
        private final Instantiator instantiator;

        public DependencyResolveDetailsWrapperAction(Action<? super DependencyResolveDetails> delegate, ComponentSelectorConverter componentSelectorConverter, Supplier<Action<? super ArtifactSelectionDetails>> artifactSelectionAction, Instantiator instantiator) {
            super(artifactSelectionAction);
            this.delegate = delegate;
            this.componentSelectorConverter = componentSelectorConverter;
            this.instantiator = instantiator;
        }

        @Override
        public void execute(DependencySubstitution substitution) {
            super.execute(substitution);
            ModuleVersionIdentifier requested = this.componentSelectorConverter.getModuleVersionId(substitution.getRequested());
            DefaultDependencyResolveDetails details = (DefaultDependencyResolveDetails)this.instantiator.newInstance(DefaultDependencyResolveDetails.class, new Object[]{substitution, requested});
            this.delegate.execute((Object)details);
            details.complete();
        }
    }

    public static class DefaultVariantSelectionDetails
    implements VariantSelectionDetails {
        private final AttributesFactory attributesFactory;
        private final ObjectFactory objectFactory;
        private final NotationParser<Object, Capability> capabilityNotationParser;
        private ComponentSelector selector;

        @Inject
        public DefaultVariantSelectionDetails(AttributesFactory attributesFactory, ObjectFactory objectFactory, NotationParser<Object, Capability> capabilityNotationParser, ComponentSelector selector) {
            this.attributesFactory = attributesFactory;
            this.objectFactory = objectFactory;
            this.capabilityNotationParser = capabilityNotationParser;
            this.selector = selector;
        }

        private void createComponentOfCategory(String category) {
            if (this.selector instanceof ProjectComponentSelector) {
                AttributeContainerInternal container = this.createCategory(category);
                this.selector = DefaultProjectComponentSelector.withAttributes((ProjectComponentSelector)this.selector, container.asImmutable());
            } else if (this.selector instanceof ModuleComponentSelector) {
                AttributeContainerInternal container = this.createCategory(category);
                this.selector = DefaultModuleComponentSelector.withAttributes((ModuleComponentSelector)this.selector, container.asImmutable());
            }
        }

        private AttributeContainerInternal createCategory(String category) {
            return (AttributeContainerInternal)this.attributesFactory.mutable().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objectFactory.named(Category.class, category)));
        }

        public void platform() {
            this.createComponentOfCategory("platform");
        }

        public void enforcedPlatform() {
            this.createComponentOfCategory("enforced-platform");
        }

        public void library() {
            this.createComponentOfCategory("library");
        }

        public void attributes(Action<? super AttributeContainer> configurationAction) {
            AttributeContainerInternal container = this.attributesFactory.mutable();
            configurationAction.execute((Object)container);
            if (this.selector instanceof ProjectComponentSelector) {
                this.selector = DefaultProjectComponentSelector.withAttributes((ProjectComponentSelector)this.selector, container.asImmutable());
            } else if (this.selector instanceof ModuleComponentSelector) {
                this.selector = DefaultModuleComponentSelector.withAttributes((ModuleComponentSelector)this.selector, container.asImmutable());
            }
        }

        public void capabilities(Action<? super ModuleDependencyCapabilitiesHandler> configurationAction) {
            ModuleDependencyCapabilitiesInternal handler = (ModuleDependencyCapabilitiesInternal)this.objectFactory.newInstance(DefaultMutableModuleDependencyCapabilitiesHandler.class, new Object[]{this.capabilityNotationParser});
            configurationAction.execute((Object)handler);
            if (this.selector instanceof ProjectComponentSelector) {
                this.selector = DefaultProjectComponentSelector.withCapabilities((ProjectComponentSelector)this.selector, (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf((Collection)((Collection)handler.getCapabilitySelectors().get())));
            } else if (this.selector instanceof ModuleComponentSelector) {
                this.selector = DefaultModuleComponentSelector.withCapabilities((ModuleComponentSelector)this.selector, (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf((Collection)((Collection)handler.getCapabilitySelectors().get())));
            }
        }
    }

    private static class NoArtifactSelector
    implements Action<ArtifactSelectionDetails> {
        private static final NoArtifactSelector INSTANCE = new NoArtifactSelector();

        private NoArtifactSelector() {
        }

        public void execute(ArtifactSelectionDetails artifactSelectionDetails) {
            artifactSelectionDetails.withoutArtifactSelectors();
        }
    }

    private static class NoClassifier
    implements Action<ArtifactSelectionDetails> {
        private static final NoClassifier INSTANCE = new NoClassifier();

        private NoClassifier() {
        }

        public void execute(ArtifactSelectionDetails artifactSelectionDetails) {
            artifactSelectionDetails.selectArtifact("jar", null, null);
        }
    }

    private static class SetClassifier
    implements Action<ArtifactSelectionDetails> {
        private final String classifier;

        public SetClassifier(String classifier) {
            this.classifier = classifier;
        }

        public void execute(ArtifactSelectionDetails artifactSelectionDetails) {
            artifactSelectionDetails.selectArtifact("jar", null, this.classifier);
        }
    }

    private static class ModuleMatchDependencySubstitutionAction
    extends AbstractDependencySubstitutionAction {
        private final ComponentSelectionDescriptorInternal selectionReason;
        private final ModuleIdentifier moduleId;
        private final ComponentSelector substitute;

        public ModuleMatchDependencySubstitutionAction(ComponentSelectionDescriptorInternal selectionReason, ModuleIdentifier moduleId, ComponentSelector substitute, Supplier<Action<? super ArtifactSelectionDetails>> artifactSelectionAction) {
            super(artifactSelectionAction);
            this.selectionReason = selectionReason;
            this.moduleId = moduleId;
            this.substitute = substitute;
        }

        @Override
        public void execute(DependencySubstitution dependencySubstitution) {
            ModuleComponentSelector requested;
            if (dependencySubstitution.getRequested() instanceof ModuleComponentSelector && this.moduleId.equals((requested = (ModuleComponentSelector)dependencySubstitution.getRequested()).getModuleIdentifier())) {
                super.execute(dependencySubstitution);
                ((DependencySubstitutionInternal)dependencySubstitution).useTarget(this.substitute, this.selectionReason);
            }
        }
    }

    private static class ExactMatchDependencySubstitutionAction
    extends AbstractDependencySubstitutionAction {
        private final ComponentSelectionDescriptorInternal selectionReason;
        private final ComponentSelector substituted;
        private final ComponentSelector substitute;

        public ExactMatchDependencySubstitutionAction(ComponentSelectionDescriptorInternal selectionReason, ComponentSelector substituted, ComponentSelector substitute, Supplier<Action<? super ArtifactSelectionDetails>> artifactSelectionAction) {
            super(artifactSelectionAction);
            this.selectionReason = selectionReason;
            this.substituted = substituted;
            this.substitute = substitute;
        }

        @Override
        public void execute(DependencySubstitution dependencySubstitution) {
            if (this.substituted.equals(dependencySubstitution.getRequested())) {
                super.execute(dependencySubstitution);
                ((DependencySubstitutionInternal)dependencySubstitution).useTarget(this.substitute, this.selectionReason);
            }
        }
    }

    private static abstract class AbstractDependencySubstitutionAction
    implements Action<DependencySubstitution> {
        private final Supplier<Action<? super ArtifactSelectionDetails>> artifactSelectionAction;

        protected AbstractDependencySubstitutionAction(Supplier<Action<? super ArtifactSelectionDetails>> artifactSelectionAction) {
            this.artifactSelectionAction = artifactSelectionAction;
        }

        public void execute(DependencySubstitution dependencySubstitution) {
            dependencySubstitution.artifactSelection(this.artifactSelectionAction.get());
        }
    }

    private static class CompositeBuildSubstitutionAction
    implements Action<DependencySubstitution> {
        private final Action<? super DependencySubstitution> delegate;

        private CompositeBuildSubstitutionAction(Action<? super DependencySubstitution> delegate) {
            this.delegate = delegate;
        }

        public void execute(DependencySubstitution dependencySubstitution) {
            final DependencySubstitutionInternal ds = (DependencySubstitutionInternal)dependencySubstitution;
            this.delegate.execute((Object)new DependencySubstitutionInternal(){

                @Override
                public ComponentSelector getTarget() {
                    return ds.getTarget();
                }

                @Override
                public List<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
                    return ds.getRuleDescriptors();
                }

                @Override
                public boolean isUpdated() {
                    return ds.isUpdated();
                }

                @Override
                public ArtifactSelectionDetailsInternal getArtifactSelectionDetails() {
                    return ds.getArtifactSelectionDetails();
                }

                public ComponentSelector getRequested() {
                    return ds.getRequested();
                }

                private Object addImplicitRequestAttributesAndCapabilities(Object notation) {
                    if (notation instanceof ProjectComponentSelector) {
                        ProjectComponentSelector projectSelector = (ProjectComponentSelector)notation;
                        ComponentSelector requested = this.getRequested();
                        return DefaultProjectComponentSelector.withAttributesAndCapabilities(projectSelector, ((AttributeContainerInternal)requested.getAttributes()).asImmutable(), (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf((Collection)requested.getCapabilitySelectors()));
                    }
                    return notation;
                }

                @Override
                public void useTarget(Object notation, ComponentSelectionDescriptor ruleDescriptor) {
                    ds.useTarget(this.addImplicitRequestAttributesAndCapabilities(notation), ruleDescriptor);
                }

                public void useTarget(Object notation) {
                    ds.useTarget(this.addImplicitRequestAttributesAndCapabilities(notation));
                }

                public void useTarget(Object notation, String reason) {
                    ds.useTarget(this.addImplicitRequestAttributesAndCapabilities(notation), reason);
                }

                public void artifactSelection(Action<? super ArtifactSelectionDetails> action) {
                    ds.artifactSelection(action);
                }
            });
        }
    }
}

