/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.AbstractDependencyMetadataAdapter;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.ivy.IvyDependencyMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DirectDependencyMetadataAdapter
extends AbstractDependencyMetadataAdapter<DirectDependencyMetadata>
implements DirectDependencyMetadata {
    public DirectDependencyMetadataAdapter(AttributesFactory attributesFactory, ModuleDependencyMetadata metadata) {
        super(attributesFactory, metadata);
    }

    public void endorseStrictVersions() {
        this.updateMetadata(this.getMetadata().withEndorseStrictVersions(true));
    }

    public void doNotEndorseStrictVersions() {
        this.updateMetadata(this.getMetadata().withEndorseStrictVersions(false));
    }

    public boolean isEndorsingStrictVersions() {
        return this.getMetadata().isEndorsingStrictVersions();
    }

    public List<DependencyArtifact> getArtifactSelectors() {
        return this.getIvyArtifacts().stream().map(this::asDependencyArtifact).collect(Collectors.toList());
    }

    private DependencyArtifact asDependencyArtifact(IvyArtifactName ivyArtifactName) {
        return new DefaultDependencyArtifact(ivyArtifactName.getName(), ivyArtifactName.getType(), ivyArtifactName.getExtension(), ivyArtifactName.getClassifier(), null);
    }

    private List<IvyArtifactName> getIvyArtifacts() {
        ModuleDependencyMetadata originalMetadata = this.getMetadata();
        if (originalMetadata instanceof MavenDependencyMetadata) {
            MavenDependencyMetadata mavenMetadata = (MavenDependencyMetadata)originalMetadata;
            return this.fromMavenDescriptor(mavenMetadata.getDependencyDescriptor());
        }
        if (originalMetadata instanceof IvyDependencyMetadata) {
            IvyDependencyMetadata ivyMetadata = (IvyDependencyMetadata)originalMetadata;
            return this.fromIvyDescriptor(ivyMetadata.getDependencyDescriptor());
        }
        if (originalMetadata instanceof GradleDependencyMetadata) {
            return this.fromGradleMetadata((GradleDependencyMetadata)originalMetadata);
        }
        return Collections.emptyList();
    }

    private List<IvyArtifactName> fromGradleMetadata(GradleDependencyMetadata metadata) {
        IvyArtifactName artifact = metadata.getDependencyArtifact();
        if (artifact != null) {
            return Collections.singletonList(artifact);
        }
        return Collections.emptyList();
    }

    private List<IvyArtifactName> fromIvyDescriptor(IvyDependencyDescriptor descriptor) {
        List<Artifact> artifacts = descriptor.getDependencyArtifacts();
        return artifacts.stream().map(Artifact::getArtifactName).collect(Collectors.toList());
    }

    private List<IvyArtifactName> fromMavenDescriptor(MavenDependencyDescriptor descriptor) {
        IvyArtifactName artifact = descriptor.getDependencyArtifact();
        if (artifact != null) {
            return Collections.singletonList(artifact);
        }
        return Collections.emptyList();
    }
}

