/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public abstract Optional<L> getLeft();

    public abstract Optional<R> getRight();

    public abstract <U, V> Either<U, V> mapLeft(Function<? super L, ? extends U> var1);

    public abstract <U, V> Either<U, V> mapRight(Function<? super R, ? extends V> var1);

    public abstract <U> U fold(Function<? super L, ? extends U> var1, Function<? super R, ? extends U> var2);

    public abstract void apply(Consumer<? super L> var1, Consumer<? super R> var2);

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private static class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = value;
        }

        @Override
        public Optional<L> getLeft() {
            return Optional.of(this.value);
        }

        @Override
        public Optional<R> getRight() {
            return Optional.empty();
        }

        @Override
        public <U, V> Either<U, V> mapLeft(Function<? super L, ? extends U> f) {
            return new Left<U, R>(f.apply(this.value));
        }

        @Override
        public <U, V> Either<U, V> mapRight(Function<? super R, ? extends V> f) {
            return this;
        }

        @Override
        public <U> U fold(Function<? super L, ? extends U> l, Function<? super R, ? extends U> r) {
            return l.apply(this.value);
        }

        @Override
        public void apply(Consumer<? super L> l, Consumer<? super R> r) {
            l.accept(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value.equals(((Left)o).value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "Left(" + this.value + ")";
        }
    }

    private static class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = value;
        }

        @Override
        public Optional<L> getLeft() {
            return Optional.empty();
        }

        @Override
        public Optional<R> getRight() {
            return Optional.of(this.value);
        }

        @Override
        public <U, V> Either<U, V> mapLeft(Function<? super L, ? extends U> f) {
            return this;
        }

        @Override
        public <U, V> Either<U, V> mapRight(Function<? super R, ? extends V> f) {
            return new Right<L, V>(f.apply(this.value));
        }

        @Override
        public <U> U fold(Function<? super L, ? extends U> l, Function<? super R, ? extends U> r) {
            return r.apply(this.value);
        }

        @Override
        public void apply(Consumer<? super L> l, Consumer<? super R> r) {
            r.accept(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value.equals(((Right)o).value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "Right(" + this.value + ")";
        }
    }
}

