plugins {
    `java-library`
}

repositories {
    mavenCentral()
}

// tag::dependencies[]
dependencies {
    implementation("org.codehaus.groovy:groovy:3.0.1")
    runtimeOnly("io.vertx:vertx-lang-groovy:3.9.4")
}
// end::dependencies[]

if (project.hasProperty("explicitRule")) {
    // tag::explicit-configuration[]
    configurations {
        runtimeClasspath.get().shouldResolveConsistentlyWith(compileClasspath.get())
    }
    // end::explicit-configuration[]
}

if (project.hasProperty("javaConvention")) {
    // tag::java-convention[]
    java {
        consistentResolution {
            useCompileClasspathVersions()
        }
    }
    // end::java-convention[]
}
