/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSetFactory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class DefaultDirectoryFileTreeFactory
implements DirectoryFileTreeFactory {
    private final PatternSetFactory patternSetFactory;
    private final FileSystem fileSystem;

    public DefaultDirectoryFileTreeFactory() {
        this.patternSetFactory = new PatternSetFactory(){

            public PatternSet createPatternSet() {
                return new PatternSet();
            }
        };
        this.fileSystem = FileSystems.getDefault();
    }

    public DefaultDirectoryFileTreeFactory(PatternSetFactory patternSetFactory, FileSystem fileSystem) {
        this.patternSetFactory = patternSetFactory;
        this.fileSystem = fileSystem;
    }

    @Override
    public DirectoryFileTree create(File directory) {
        return new DirectoryFileTree(directory, this.patternSetFactory.createPatternSet(), this.fileSystem);
    }

    @Override
    public DirectoryFileTree create(File directory, PatternSet patternSet) {
        return new DirectoryFileTree(directory, patternSet, this.fileSystem);
    }
}

