/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;

public final class CompoundRuntimeException
extends RuntimeException {
    private final List<? extends Throwable> exceptions;

    public CompoundRuntimeException(@NotNull List<? extends Throwable> throwables) {
        if (throwables == null) {
            CompoundRuntimeException.$$$reportNull$$$0(0);
        }
        this.exceptions = throwables;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.exceptions.isEmpty() ? null : this.exceptions.get(0);
    }

    @Override
    public String getMessage() {
        return this.processAll(Throwable::getMessage, null).toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.processAll(Throwable::getLocalizedMessage, null).toString();
    }

    @Override
    public String toString() {
        return this.processAll(Throwable::toString, null).toString();
    }

    @Override
    public void printStackTrace(@NotNull PrintStream s2) {
        if (s2 == null) {
            CompoundRuntimeException.$$$reportNull$$$0(1);
        }
        this.processAll(throwable -> {
            throwable.printStackTrace(s2);
            return "";
        }, s2::print);
    }

    @Override
    public void printStackTrace(@NotNull PrintWriter s2) {
        if (s2 == null) {
            CompoundRuntimeException.$$$reportNull$$$0(2);
        }
        this.processAll(throwable -> {
            throwable.printStackTrace(s2);
            return "";
        }, s2::print);
    }

    @NotNull
    private CharSequence processAll(@NotNull Function<? super Throwable, String> exceptionProcessor, @Nullable Consumer<? super String> stringProcessor) {
        if (exceptionProcessor == null) {
            CompoundRuntimeException.$$$reportNull$$$0(3);
        }
        if (this.exceptions.size() == 1) {
            Throwable throwable = this.exceptions.get(0);
            String s2 = exceptionProcessor.apply(throwable);
            if (stringProcessor != null) {
                stringProcessor.accept(s2);
            }
            String string = s2;
            if (string == null) {
                CompoundRuntimeException.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        String line = "CompositeException (" + this.exceptions.size() + " nested):\n------------------------------\n";
        if (stringProcessor != null) {
            stringProcessor.accept(line);
        }
        sb.append(line);
        for (int i2 = 0; i2 < this.exceptions.size(); ++i2) {
            Throwable exception = this.exceptions.get(i2);
            line = "[" + (i2 + 1) + "]: ";
            if (stringProcessor != null) {
                stringProcessor.accept(line);
            }
            sb.append(line);
            line = exceptionProcessor.apply(exception);
            if (line == null) {
                line = "null\n";
            } else if (!line.endsWith("\n")) {
                line = line + '\n';
            }
            if (stringProcessor != null) {
                stringProcessor.accept(line);
            }
            sb.append(line);
        }
        line = "------------------------------\n";
        if (stringProcessor != null) {
            stringProcessor.accept(line);
        }
        sb.append(line);
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            CompoundRuntimeException.$$$reportNull$$$0(5);
        }
        return stringBuilder;
    }

    public static void throwIfNotEmpty(@Nullable List<? extends Throwable> throwables) {
        if (throwables == null || throwables.isEmpty()) {
            return;
        }
        if (throwables.size() != 1) {
            throw new CompoundRuntimeException(throwables);
        }
        ExceptionUtil.rethrow(throwables.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwables";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionProcessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/CompoundRuntimeException";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/CompoundRuntimeException";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processAll";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "printStackTrace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

